/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.text.TextUtils;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttMessage;
import com.xdja.pushsdk.aidl.IGuardService;
import com.xdja.pushsdk.http.bean.NotifyBean;
import com.xdja.pushsdk.npc.manager.MessageManager;
import com.xdja.pushsdk.npc.service.MqttConnection;
import com.xdja.pushsdk.npc.service.MqttServiceCallBack;
import com.xdja.pushsdk.npc.service.MqttServiceReceiver;
import com.xdja.pushsdk.provider.PushFuncProvider;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.NetState;
import com.xdja.pushsdk.utils.ProviderUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MqttService
extends Service
implements MqttServiceCallBack {
    protected static final String TAG = "MqttService";
    protected static Map<String, String> topicByPg = new HashMap<String, String>();
    private static Map<String, IGuardService> AIDLBinders = new HashMap<String, IGuardService>();
    private static MqttConnection mqttConnection;
    private IGuardService mBinder;
    private NPCServiceConnection mConn;
    private MqttServiceReceiver mServiceReceiver;
    private boolean bindDisConnect = false;

    public void onCreate() {
        super.onCreate();
        this.initMqttService();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        LogHelper.getHelper().i("mqtt onDestroy");
        this.unRegisterBroadcastReceivers();
        this.unbindGuardService();
        if (mqttConnection != null) {
            mqttConnection.disconnect(null, null);
        }
        super.onDestroy();
    }

    private void initMqttService() {
        this.mConn = new NPCServiceConnection();
        PushFuncProvider.setTopicCallBack(this);
        this.registerBroadcastReceivers();
        mqttConnection = new MqttConnection(this);
        mqttConnection.initConnect(this);
        MqttServiceReceiver.setMqttConnectCallBack(mqttConnection);
        PushFuncProvider.setMqttConnectCallBack(mqttConnection);
    }

    private void registerBroadcastReceivers() {
        LogHelper.getHelper().d("Register MqttWork Broadcast");
        if (this.mServiceReceiver == null) {
            this.mServiceReceiver = new MqttServiceReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.registerReceiver(this.mServiceReceiver, filter);
        }
    }

    private void unRegisterBroadcastReceivers() {
        LogHelper.getHelper().d("Unregister MqttWork Broadcast");
        if (this.mServiceReceiver != null) {
            try {
                this.unregisterReceiver(this.mServiceReceiver);
            }
            catch (Exception e) {
                LogHelper.getHelper().i("This receiver unRegisterBroadcastReceiver  suiye:" + e.getMessage());
            }
        }
    }

    private void unbindGuardService() {
        LogHelper.getHelper().d("UnbindGuardService");
        try {
            if (this.mConn != null) {
                this.unbindService(this.mConn);
            }
        }
        catch (Exception e) {
            LogHelper.getHelper().i("mConn is unbindService  e:" + e.getMessage());
        }
    }

    public void messageArrivedSender(String topic, NotifyBean notifyBean) {
        LogHelper.getHelper().i("Mqtt Msg Comming");
        if (!TextUtils.isEmpty((CharSequence)topic) && topic.contains("@SYS/notice/")) {
            if (("@SYS/notice/" + mqttConnection.getClientId()).equalsIgnoreCase(topic)) {
                LogHelper.getHelper().i("@SYS/notice/");
                this.unsubscribe("UNREGISTER_PUSH", this.getPackageName());
                try {
                    ProviderUtil.getPushNotifyBinder((Context)this, this.getPackageName()).unbindNpc();
                }
                catch (Exception e) {
                    LogHelper.getHelper().i("unbindNpc fail");
                }
            } else {
                LogHelper.getHelper().i("@SYS/notice cid is not same");
            }
        } else if (notifyBean != null && notifyBean.getType() == 6) {
            MessageManager.getInstance((Context)this).getNotifyStr(topic, notifyBean, this.getPackageName());
        } else {
            MessageManager.getInstance((Context)this).getNotifyStr(topic, notifyBean, topicByPg.get(topic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            topicByPg.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disSubscribe(String[] topics) {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            for (String topic : topics) {
                topicByPg.remove(topic);
            }
        }
    }

    public void pullHisMsg(String topic) {
        if (topicByPg.get(topic) != null) {
            NotifyBean notifyBean = new NotifyBean();
            notifyBean.setContext("PULL_HISTORY_MSG");
            MessageManager.getInstance((Context)this).getNotifyStr(topic, notifyBean, topicByPg.get(topic));
        }
    }

    public boolean subscribe(List<String> topics) {
        if (mqttConnection == null || !mqttConnection.isConnected()) {
            LogHelper.getHelper().d("initSub fail by client is not online");
            return false;
        }
        int[] qoss = new int[topics.size()];
        String[] tpcs = new String[topics.size()];
        topics.toArray(tpcs);
        mqttConnection.subscribe(tpcs, qoss, null, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic, String pg) {
        Map<String, String> map = topicByPg;
        synchronized (map) {
            if (topic.equals("UNREGISTER_PUSH")) {
                Set<String> topics = topicByPg.keySet();
                ArrayList<String> tpcs = new ArrayList<String>();
                tpcs.addAll(topics);
                for (int i = 0; i < tpcs.size(); ++i) {
                    if (!topicByPg.get(tpcs.get(i)).equals(pg) || mqttConnection == null || !mqttConnection.isConnected()) continue;
                    topicByPg.remove(tpcs.get(i));
                    mqttConnection.unsubscribe((String)tpcs.get(i), null, null);
                    LogHelper.getHelper().d("unsubscribe topic--->>" + (String)tpcs.get(i));
                }
            } else if (mqttConnection != null && mqttConnection.isConnected()) {
                topicByPg.remove(topic);
                mqttConnection.unsubscribe(topic, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(List<String> topics, String pg) {
        if (mqttConnection != null && mqttConnection.isConnected()) {
            Map<String, String> map = topicByPg;
            synchronized (map) {
                for (String topic : topics) {
                    topicByPg.remove(topic);
                }
            }
            String[] tpcs = new String[topics.size()];
            topics.toArray(tpcs);
            mqttConnection.unsubscribe(tpcs, null, null);
        }
    }

    public void publishMsg(String message, String topic) {
        if (mqttConnection != null && mqttConnection.isConnected()) {
            byte[] payload = message.getBytes();
            MqttMessage msg = null;
            msg = payload != null ? new MqttMessage(payload) : new MqttMessage();
            msg.setQos(0);
            msg.setRetained(false);
            mqttConnection.publish(topic, msg, null, null);
        }
    }

    public void mqttConnectSuccess() {
        LogHelper.getHelper().i("NPCS broadcast invite subscribe");
        try {
            ProviderUtil.getPushNotifyBinder((Context)this, this.getPackageName()).pushInviteSub(this.getPackageName(), mqttConnection.getClientId());
        }
        catch (Exception e) {
            LogHelper.getHelper().e("NPCS broadcast invite subscribe fail");
        }
        String net = NetState.getNetworkType((Context)this);
        LogHelper.getHelper().i("mqtt connected and net is " + net);
        this.sendPushCode("10000");
    }

    public void sendPushCode(String code) {
        try {
            ProviderUtil.getPushNotifyBinder((Context)this, this.getPackageName()).pushStateChange(code);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean bindTargetAIDLService(String pg) {
        Intent in = new Intent();
        in.setAction("com.xdja.service.guardservice");
        in.setPackage(pg);
        this.startService(in);
        boolean isSuccess = this.bindService(in, this.mConn, 1);
        LogHelper.getHelper().d("AIDLServiceTarget---" + pg + "---" + isSuccess);
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subTopic(List<String> topics, String pg) {
        boolean bindState = false;
        ArrayList<String> topicsSub = new ArrayList<String>();
        if (topics != null && pg != null) {
            bindState = this.bindTargetAIDLService(pg);
            Map<String, String> map = topicByPg;
            synchronized (map) {
                for (String topic : topics) {
                    if (topicByPg.containsKey(topic)) continue;
                    topicByPg.put(topic, pg);
                    topicsSub.add(topic);
                    LogHelper.getHelper().d("subtopic::" + topic + "  pg::" + pg);
                }
            }
            if (topicsSub.size() == 0) {
                return false;
            }
            if (!this.subscribe(topicsSub)) {
                map = topicByPg;
                synchronized (map) {
                    for (String topic : topicsSub) {
                        topicByPg.remove(topic);
                    }
                }
            }
        }
        return bindState;
    }

    @Override
    public void unsubTopic(List<String> topics, String pg) {
        if (topics != null && pg != null) {
            if (topics.size() == 1) {
                this.unsubscribe(topics.get(0), pg);
            } else if (topics.size() > 1) {
                this.unsubscribe(topics, pg);
            }
        }
    }

    @Override
    public void deliverMsg(String message, String topic) {
        if (message != null && topic != null) {
            this.publishMsg(message, topic);
        }
    }

    @Override
    public void stopPush() {
        if (mqttConnection != null) {
            mqttConnection.disconnect(null, null, new IMqttActionListener(){

                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    MqttService.this.unbindGuardService();
                    MqttService.this.stopSelf();
                    System.exit(0);
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    MqttService.this.unbindGuardService();
                    MqttService.this.stopSelf();
                    System.exit(0);
                }
            });
        }
    }

    private final class NPCServiceConnection
    implements ServiceConnection {
        private NPCServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Map map = AIDLBinders;
            synchronized (map) {
                AIDLBinders.remove(name.getPackageName());
            }
            MqttService.this.bindTargetAIDLService(name.getPackageName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            MqttService.this.mBinder = IGuardService.Stub.asInterface(service);
            try {
                MqttService.this.mBinder.isRunningNPCPackage(MqttService.this.getPackageName());
            }
            catch (Exception e) {
                LogHelper.getHelper().e("onServiceConnected....fail");
            }
            Map map = AIDLBinders;
            synchronized (map) {
                AIDLBinders.put(name.getPackageName(), MqttService.this.mBinder);
            }
            MqttService.this.bindDisConnect = false;
            LogHelper.getHelper().d("onServiceConnected....");
        }
    }
}

