/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.xdja.pushsdk.NPCManager;
import com.xdja.pushsdk.npc.service.MqttConnectCallback;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.ProviderUtil;
import com.xdja.pushsdk.utils.XDJAExecutorService;

public class MqttServiceReceiver
extends BroadcastReceiver {
    private static MqttConnectCallback mqttConnectCallback;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.ACTION_POWER_CONNECTED".equals(action) || "android.intent.action.ACTION_POWER_DISCONNECTED".equals(action) || "android.intent.action.USER_PRESENT".equals(action) || "android.intent.action.SCREEN_ON".equals(action) || "android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            LogHelper.getHelper().d("\u6536\u5230\u7cfb\u7edf\u5e7f\u64ad\uff0c\u68c0\u6d4b\u662f\u5426\u63a8\u9001\u8fd8\u5728\u8fd0\u884c-->>");
            if (!NPCManager.isNPCService(context)) {
                LogHelper.getHelper().d("\u6536\u5230\u91cd\u542f\u5e7f\u64ad,\u65e0NPCS\u5b58\u5728\uff0c\u91cd\u542f");
                this.reStartNPCS(context);
            } else if (mqttConnectCallback != null) {
                LogHelper.getHelper().i("NetWork is Changed and checkPing");
                mqttConnectCallback.checkPing();
            }
        }
    }

    public static void setMqttConnectCallBack(MqttConnectCallback callBack) {
        mqttConnectCallback = callBack;
    }

    private void reStartNPCS(Context context) {
        XDJAExecutorService.BUSINESS_LIMITED_TASK_EXECUTOR.execute(new StartNpcsTask(context));
    }

    class StartNpcsTask
    implements Runnable {
        Context context;

        public StartNpcsTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (NPCManager.isNPCService(this.context)) {
                LogHelper.getHelper().i("NPCRec:npcs exist, don't restart npcs");
                return;
            }
            LogHelper.getHelper().i("NPCRec:npcs not exist , restart npcs");
            try {
                String appId = ProviderUtil.getPushNotifyBinder(this.context, this.context.getPackageName()).getAppId();
                LogHelper.getHelper().d("getAppid::" + appId);
                if (appId.equals("0")) {
                    LogHelper.getHelper().i("can't find clientid and can't start pushservice");
                    return;
                }
            }
            catch (Exception e) {
                LogHelper.getHelper().e("start pushservice fail code 1002");
                return;
            }
            Intent intent2 = new Intent();
            intent2.setPackage(this.context.getPackageName());
            intent2.setAction("com.xdja.PushService");
            this.context.startService(intent2);
        }
    }
}

