/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.utils;

import android.util.Log;

public class LogHelper {
    private static final String TAG = "xpush_sdk_log";
    private static final int LOG_LEVEL = 2;
    private static final boolean LOG_MINIF = false;
    private String mClassName;
    private static LogHelper logger;

    private LogHelper() {
    }

    private LogHelper(String name) {
        this.mClassName = name;
    }

    public static LogHelper getHelper(String Tag) {
        if (logger == null) {
            logger = new LogHelper(Tag);
        }
        return logger;
    }

    public static LogHelper getHelper() {
        if (logger == null) {
            logger = new LogHelper();
        }
        return logger;
    }

    private String getFunctionName() {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        for (StackTraceElement st : sts) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName())) continue;
            return "[ " + Thread.currentThread().getName() + ": " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + " ]";
        }
        return null;
    }

    public void i(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.i((String)TAG, (String)(name + " - " + str));
        } else {
            Log.i((String)TAG, (String)str.toString());
        }
    }

    public void d(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.d((String)TAG, (String)(name + " - " + str));
        } else {
            Log.d((String)TAG, (String)str.toString());
        }
    }

    public void v(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.v((String)TAG, (String)(name + " - " + str));
        } else {
            Log.v((String)TAG, (String)str.toString());
        }
    }

    public void w(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.w((String)TAG, (String)(name + " - " + str));
        } else {
            Log.w((String)TAG, (String)str.toString());
        }
    }

    public void e(Object str) {
        String name = this.getFunctionName();
        if (name != null) {
            Log.e((String)TAG, (String)(name + " - " + str));
        } else {
            Log.e((String)TAG, (String)str.toString());
        }
    }

    public void e(Exception ex) {
        Log.e((String)TAG, (String)"error", (Throwable)ex);
    }

    public void e(String log, Throwable tr) {
        if (log != null) {
            String line = this.getFunctionName();
            Log.e((String)TAG, (String)("{Thread:" + Thread.currentThread().getName() + "}" + "[" + line + ":] " + log + "\n"), (Throwable)tr);
        } else {
            Log.e((String)TAG, (String)("{Thread:" + Thread.currentThread().getName() + "}" + log + "\n"), (Throwable)tr);
        }
    }
}

