/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.xdja.pushsdk.utils.EncryptUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedPreUtils {
    public static final String WEB_API_IP = "webApiIp";
    public static final String WEB_API_PORT = "webApiPort";
    public static final String WEB_API_TYPE = "webApiType";
    public static final String CLIENT_ID = "clientid";
    public static final String INIT_DEVID = "INIT_DEVID";
    public static final String NPSWEB_PARAM = "NPSWEB_PARAM";
    public static final String PUSH_STATE = "PUSH_STATE";
    public static final String STATE = "state";
    public static final String TOPIC_HIS = "TOPIC_HIS_2.0";
    public static final String INIT_CID = "INIT_CID";
    public static final String CONNID = "connid";
    public static final String PUSH_BIND_STATE = "PUSH_BIND_STATE";
    public static final String DEFAULT_CLIENT_ID = "0";
    public static final String DEFAULT_KEY = "-1";
    public static final String DEFAULT_STRING_OTHER = "0";
    public static final String DEFAULT_VALUE_STRING = "0";
    public static final int DEFAULT_VALUE_INTEGER = 0;
    public static final int DEFAULT_VALUE_BIND = 0;
    public static final String INIT_APPID = "appId";
    public static final String INIT_USERID = "userId";
    public static final String INIT_KEY = "key";

    private static void commitSharedPre(Context context, String tag, Map<String, Object> values) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        for (String key : values.keySet()) {
            if (values.get(key) instanceof Integer) {
                editor.putInt(key, ((Integer)values.get(key)).intValue());
                continue;
            }
            if (!(values.get(key) instanceof String)) continue;
            editor.putString(key, (String)values.get(key));
        }
        editor.clear();
        editor.apply();
    }

    @SuppressLint(value={"NewApi"})
    private static void commitSharedPreSet(Context context, String tag, Map<String, Set<String>> values) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        for (String key : values.keySet()) {
            editor.putStringSet(key, values.get(key));
        }
        editor.apply();
    }

    @SuppressLint(value={"NewApi"})
    private static Object getSharedPre(Context context, String tag, String key, Object defaultValue) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        Object value = null;
        if (defaultValue instanceof Integer) {
            value = sp.getInt(key, ((Integer)defaultValue).intValue());
        } else if (defaultValue instanceof String) {
            value = sp.getString(key, (String)defaultValue);
        } else if (defaultValue instanceof Set) {
            value = sp.getStringSet(key, (Set)defaultValue);
        }
        return value;
    }

    public static void clearSharedPre(Context context, String tag) {
        SharedPreferences sp = context.getSharedPreferences(tag, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        editor.apply();
    }

    public static void savePushClientId(Context context, String appId, String userId, String key) {
        appId = EncryptUtil.encrypt(appId, key);
        userId = EncryptUtil.encrypt(userId, key);
        HashMap<String, Object> initValues = new HashMap<String, Object>();
        initValues.put(INIT_APPID, appId);
        initValues.put(INIT_USERID, userId);
        initValues.put(INIT_KEY, key);
        SharedPreUtils.commitSharedPre(context, INIT_DEVID, initValues);
    }

    public static void savePushState(Context context, int state) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE, state);
        SharedPreUtils.commitSharedPre(context, PUSH_STATE, map);
    }

    public static void savePushConnid(Context context, String connid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CONNID, connid);
        SharedPreUtils.commitSharedPre(context, INIT_CID, map);
    }

    public static void saveTopics(Context context, List<String> topics) {
        String encTopic;
        int i;
        String key = SharedPreUtils.getKey(context);
        ArrayList<String> encTopics = new ArrayList<String>(topics);
        HashSet<String> topicSet = new HashSet<String>();
        List<String> tpcs = SharedPreUtils.getPushTopics(context);
        for (i = 0; i < tpcs.size(); ++i) {
            encTopic = EncryptUtil.encrypt(tpcs.get(i), key);
            tpcs.set(i, encTopic);
        }
        topicSet.addAll(tpcs);
        for (i = 0; i < encTopics.size(); ++i) {
            encTopic = EncryptUtil.encrypt((String)encTopics.get(i), key);
            encTopics.set(i, encTopic);
        }
        topicSet.addAll(encTopics);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(context.getPackageName(), topicSet);
        SharedPreUtils.commitSharedPreSet(context, TOPIC_HIS, map);
    }

    public static void deleteTopics(Context context, List<String> topics) {
        List<String> tpcs = SharedPreUtils.getPushTopics(context);
        for (String topic : topics) {
            tpcs.remove(topic);
        }
        HashSet<String> topicSet = new HashSet<String>();
        topicSet.addAll(tpcs);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(context.getPackageName(), topicSet);
        SharedPreUtils.commitSharedPreSet(context, TOPIC_HIS, map);
    }

    public static String getPushClientId(Context context) {
        return (String)SharedPreUtils.getSharedPre(context, INIT_DEVID, CLIENT_ID, "0");
    }

    public static int getPushState(Context context) {
        return (Integer)SharedPreUtils.getSharedPre(context, PUSH_STATE, STATE, 0);
    }

    public static List<String> getPushTopics(Context context) {
        Set topics = new HashSet();
        topics = (Set)SharedPreUtils.getSharedPre(context, TOPIC_HIS, context.getPackageName(), topics);
        ArrayList<String> tpcs = new ArrayList<String>();
        String key = SharedPreUtils.getKey(context);
        if (DEFAULT_KEY.equalsIgnoreCase(key)) {
            return tpcs;
        }
        if (topics.size() != 0) {
            tpcs.addAll(topics);
        }
        for (int i = 0; i < tpcs.size(); ++i) {
            String encTopic = EncryptUtil.encrypt((String)tpcs.get(i), key);
            tpcs.set(i, encTopic);
        }
        return tpcs;
    }

    public static String getAppid(Context context) {
        String key = SharedPreUtils.getKey(context);
        if (DEFAULT_KEY.equalsIgnoreCase(key)) {
            return "0";
        }
        String appIdEnc = (String)SharedPreUtils.getSharedPre(context, INIT_DEVID, INIT_APPID, "0");
        return EncryptUtil.encrypt(appIdEnc, key);
    }

    public static String getUserid(Context context) {
        String userId = (String)SharedPreUtils.getSharedPre(context, INIT_DEVID, INIT_USERID, "0");
        String key = SharedPreUtils.getKey(context);
        if (DEFAULT_KEY.equalsIgnoreCase(key)) {
            return "0";
        }
        return EncryptUtil.encrypt(userId, key);
    }

    public static String getKey(Context context) {
        return (String)SharedPreUtils.getSharedPre(context, INIT_DEVID, INIT_KEY, DEFAULT_KEY);
    }

    public static String getConnid(Context context) {
        return (String)SharedPreUtils.getSharedPre(context, INIT_CID, CONNID, "0");
    }

    public static void savePushBindState(Context context, int state) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE, state);
        SharedPreUtils.commitSharedPre(context, PUSH_BIND_STATE, map);
    }

    public static int getPushBindState(Context context) {
        int state = (Integer)SharedPreUtils.getSharedPre(context, PUSH_BIND_STATE, STATE, 0);
        return state;
    }
}

