/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    private static final String FORMAT_YMDHM = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_HH_MM = "HH:mm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SimpleDateFormat getFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread != null) return formatThread.get();
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            formatThread = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(pattern);
                }
            };
            sdfMap.put(pattern, formatThread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return formatThread.get();
        }
    }

    public static String convertFileModifyDate(long timestamp) {
        if (timestamp == 0L) {
            return "";
        }
        return DateUtils.getFormat(FORMAT_YMDHM).format(timestamp);
    }

    public static String getDisplayTime(long timestamp) {
        return DateUtils.getFormat(FORMAT_HH_MM).format(timestamp);
    }
}

