/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.emoji.ui.adapter;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.image.BitmapUtils;

public class GridViewAdapter
extends BaseAdapter {
    private final Context context;
    private final String[] facesName;
    private final Resources r;

    public GridViewAdapter(Context context, String[] facesName) {
        this.context = context;
        this.facesName = facesName;
        this.r = this.context.getResources();
    }

    public int getCount() {
        return this.facesName.length;
    }

    public Object getItem(int position) {
        return this.facesName[position];
    }

    public long getItemId(int position) {
        return position;
    }

    @TargetApi(value=21)
    public View getView(int position, View convertView, ViewGroup parent) {
        GridViewHolder gridViewHolder;
        if (convertView == null) {
            gridViewHolder = new GridViewHolder();
            convertView = gridViewHolder.layoutView;
            convertView.setTag((Object)gridViewHolder);
        } else {
            gridViewHolder = (GridViewHolder)convertView.getTag();
        }
        try {
            if (position == 20) {
                gridViewHolder.faceIv.setBackground(this.context.getDrawable(R.drawable.im_uikit_bg_emoji_delete_selector));
            } else {
                gridViewHolder.faceIv.setImageBitmap(BitmapUtils.getBitmapWithName(this.facesName[position], this.context.getResources()));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    public class GridViewHolder {
        public final LinearLayout layoutView;
        public final ImageView faceIv;
        private final int faceSize;
        private final int faceMargin;

        public GridViewHolder() {
            this.faceSize = (int)GridViewAdapter.this.r.getDimension(R.dimen.im_uikit_faceitem_size);
            this.faceMargin = (int)GridViewAdapter.this.r.getDimension(R.dimen.im_uikit_faceitem_margin);
            AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(-1, -1);
            this.layoutView = new LinearLayout(GridViewAdapter.this.context);
            this.faceIv = new ImageView(GridViewAdapter.this.context);
            this.layoutView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.layoutView.setOrientation(1);
            this.layoutView.setGravity(17);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.faceSize, this.faceSize);
            params.setMargins(this.faceMargin, this.faceMargin, this.faceMargin, 8);
            this.faceIv.setLayoutParams((ViewGroup.LayoutParams)params);
            this.layoutView.addView((View)this.faceIv);
        }
    }
}

