/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ExpandableListView;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.adapter.FileListAdapter;
import com.xdja.im.lib.filemanage.commend.IFileListCommand;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.IFileListVu;
import com.xdja.im.lib.filemanage.view.ViewFileList;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rx.Subscriber;

public class FileListPresenter
extends IMFragmentPresenter<IFileListCommand, IFileListVu>
implements IFileListCommand {
    private static final int MAX_SELECT_COUNT = 9;
    private static final long MAX_SELECT_SIZE = 0x1E00000L;
    BusProvider busProvider;
    private FileListAdapter mAdapter;
    private final List<String> mGroupTitles = new ArrayList<String>();
    private final List<List<FileItem>> mLocalFileList = new ArrayList<List<FileItem>>();
    private int mFileType = 0;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == this.useCaseComponent) {
            LogUtil.e("FileListPresenter", "useCaseComponent is null");
            return;
        }
        this.useCaseComponent.inject(this);
        this.busProvider = BusProvider.getInstance();
        this.busProvider.register(this);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mFileType = bundle.getInt("file_type");
        }
        this.initViews();
        this.loadData();
    }

    private void initViews() {
        ((IFileListVu)this.getVu()).getListView().setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

            public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id2) {
                FileItem fileInfo = (FileItem)((List)FileListPresenter.this.mLocalFileList.get(groupPosition)).get(childPosition);
                if (fileInfo != null) {
                    if (!fileInfo.isSelected()) {
                        if (fileInfo.getFileSize() >= 0x1E00000L) {
                            new XToast(FileListPresenter.this.getContext()).display(FileListPresenter.this.getString(R.string.im_uikit_file_is_too_larger));
                            return false;
                        }
                        if (FileInfoCollection.getInstance().getSelectedFileCount() >= 9) {
                            new XToast(FileListPresenter.this.getContext()).display(String.format(FileListPresenter.this.getString(R.string.im_uikit_select_file_hint), 9));
                            return false;
                        }
                    }
                    fileInfo.setSelected(!fileInfo.isSelected());
                    if (fileInfo.isSelected()) {
                        FileInfoCollection.getInstance().putFileToSelectedCache(fileInfo.getFilePath() + fileInfo.getModifiedDate(), fileInfo);
                    } else {
                        FileInfoCollection.getInstance().removeToSelectedCache(fileInfo.getFilePath() + fileInfo.getModifiedDate());
                    }
                    IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(fileInfo);
                    FileListPresenter.this.busProvider.post(event);
                    ((List)FileListPresenter.this.mLocalFileList.get(groupPosition)).remove(childPosition);
                    ((List)FileListPresenter.this.mLocalFileList.get(groupPosition)).add(childPosition, fileInfo);
                    FileListPresenter.this.mAdapter.notifyDataSetChanged();
                }
                return false;
            }
        });
    }

    private void loadData() {
        ImUiKit.getInstance().getComponent().proxyRepository().queryLocalFile(this.mFileType, new Subscriber<Map<String, List<FileItem>>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ((IFileListVu)FileListPresenter.this.getVu()).setEmptyView();
            }

            public void onNext(Map<String, List<FileItem>> stringListMap) {
                if (stringListMap.size() == 0) {
                    ((IFileListVu)FileListPresenter.this.getVu()).setEmptyView();
                } else {
                    FileListPresenter.this.mGroupTitles.clear();
                    FileListPresenter.this.mLocalFileList.clear();
                    for (String key : stringListMap.keySet()) {
                        FileListPresenter.this.mGroupTitles.add(key);
                        FileListPresenter.this.mLocalFileList.add(stringListMap.get(key));
                    }
                    FileListPresenter.this.mAdapter = new FileListAdapter(FileListPresenter.this.getContext(), FileListPresenter.this.mGroupTitles);
                    FileListPresenter.this.mAdapter.addLocalFiles(FileListPresenter.this.mLocalFileList);
                    ((IFileListVu)FileListPresenter.this.getVu()).setListAdapter(FileListPresenter.this.mAdapter);
                }
            }
        });
    }

    @Override
    @NonNull
    protected Class<? extends IFileListVu> getVuClass() {
        return ViewFileList.class;
    }

    @Override
    @NonNull
    protected IFileListCommand getCommand() {
        return this;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.busProvider != null) {
            this.busProvider.unregister(this);
        }
    }
}

