/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.IBinder;
import android.text.TextUtils;
import com.xdja.im.lib.filemanage.server.PreferencesServer;
import com.xdja.im.lib.filemanage.util.ActomaContextWrapper;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.ServiceManager;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.Locale;

public class UniversalUtil {
    private static final int STATE_XPOSED_DEFAULT = -1;
    private static final int STATE_XPOSED_EXIST = 1;
    private static final int STATE_XPOSED_DESEXIST = 0;
    private static int xposedExitState = -1;
    private static final int CHECK_COUNT = 3;
    private static int C_CHECK_COUNT = 3;
    private static final String ACTION_TRIGGER_UPDATE = "com.xdja.actoma.singleupdate";
    public static final String XPOSED_SERVICE_NAME = "user.xposed.system";
    public static final String XDJA_XPOSED_SERVICE_NAME = "user.xdjaposed.system";
    private static String currentXposedServiceName = "";
    public static final int LANGUAGE_DEFAULT = 0;
    public static final int LANGUAGE_CH_SIMPLE = 1;
    public static final int LANGUAGE_EN = 2;
    private static final String FLASH_SMS_TIME = "flash_sms_time";
    private static final String SCREEN_SHORTS = "screenshots";
    private static final String ONLINE = "online";
    private static final String CIPHERTTEXT_TYPE = "cipherttext";
    private static final String THEME_STYLE = "theme_style";
    public static final int THEME_STYLE_DARK = 0;
    public static final int THEME_STYLE_LIGHT = 1;
    public static int mCurrentStyle = -1;
    private static final String LANGUAGE_TYPE = "language";

    public static void updateCall(Context context) {
        Intent intent = new Intent(ACTION_TRIGGER_UPDATE);
        context.sendBroadcast(intent);
    }

    public static String getCurrentXposeServiceName() {
        if (xposedExitState == 1) {
            return currentXposedServiceName;
        }
        return "";
    }

    private static void checkServiceByName(String serviceName) {
        while (C_CHECK_COUNT > 0) {
            IBinder binder = ServiceManager.getService(serviceName);
            if (binder != null) {
                xposedExitState = 1;
                currentXposedServiceName = serviceName;
                LogUtil.e("", "UniversalUtil currentName compare old " + currentXposedServiceName.compareTo(XPOSED_SERVICE_NAME));
                break;
            }
            xposedExitState = 0;
            --C_CHECK_COUNT;
        }
        C_CHECK_COUNT = 3;
    }

    public static int getLanguageType(Context context) {
        if (context != null) {
            String currentLocal = context.getResources().getConfiguration().locale.getLanguage();
            String currentCountry = context.getResources().getConfiguration().locale.getCountry();
            if (!TextUtils.isEmpty((CharSequence)currentLocal)) {
                if (currentLocal.compareTo(Locale.CHINESE.getLanguage()) == 0 && !TextUtils.isEmpty((CharSequence)currentCountry) && currentCountry.compareTo(Locale.CHINA.getCountry()) == 0) {
                    return 1;
                }
                if (currentLocal.compareTo(Locale.ENGLISH.getLanguage()) == 0) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static int getFlashSmsTime(Context context) {
        return PreferencesServer.getWrapper(context).gPrefIntValue("flash_sms_time-" + ActomaController.getMark());
    }

    public static void setFlashSmsTime(Context context, int time) {
        PreferencesServer.getWrapper(context).setPreferenceIntValue("flash_sms_time-" + ActomaController.getMark(), time);
    }

    public static boolean getScreenshorts(Context context) {
        return PreferencesServer.getWrapper(context).gPrefBooleanValue("screenshots-" + ActomaController.getMark(), true);
    }

    public static void setScreenshorts(Context context, boolean screenshorts) {
        PreferencesServer.getWrapper(context).setPreferenceBooleanValue("screenshots-" + ActomaController.getMark(), screenshorts);
    }

    public static boolean isOnline(Context context) {
        return PreferencesServer.getWrapper(context).gPrefBooleanValue(ONLINE, true);
    }

    public static void setOnline(Context context, boolean online) {
        PreferencesServer.getWrapper(context).setPreferenceBooleanValue(ONLINE, online);
    }

    public static boolean getCipherttext(Context context) {
        return PreferencesServer.getWrapper(context).gPrefBooleanValue("cipherttext-" + ActomaController.getMark(), true);
    }

    public static boolean isCiphert(Context context) {
        return !UniversalUtil.getCipherttext(context);
    }

    public static void setCipherttext(Context context, boolean cipherttextType) {
        PreferencesServer.getWrapper(context).setPreferenceBooleanValue("cipherttext-" + ActomaController.getMark(), cipherttextType);
    }

    public static void resetCurrentStyle() {
        mCurrentStyle = -1;
    }

    public static int getThemeStyle(Context context) {
        if (mCurrentStyle != -1) {
            return mCurrentStyle;
        }
        return PreferencesServer.getWrapper(context).gPrefIntValue("theme_style-" + ActomaController.getMark());
    }

    public static void setThemeStyle(Context context, int theme) {
        mCurrentStyle = theme;
        PreferencesServer.getWrapper(context).setPreferenceIntValue("theme_style-" + ActomaController.getMark(), theme);
    }

    public static int getLanguage(Context context) {
        return PreferencesServer.getWrapper(context).gPrefIntValue(LANGUAGE_TYPE);
    }

    public static void setLanguage(Context context, int languageType) {
        PreferencesServer.getWrapper(context).setPreferenceIntValue(LANGUAGE_TYPE, languageType);
    }

    public static Locale getLanguageConfig(Context context) {
        Locale toLocal;
        int language = UniversalUtil.getLanguage(context);
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        LogUtil.d("", "20170209UniversalUtil changeLanguageConfig language is " + language);
        switch (language) {
            case 2: {
                toLocal = Locale.ENGLISH;
                break;
            }
            case 1: {
                toLocal = Locale.CHINA;
                break;
            }
            default: {
                toLocal = ActomaContextWrapper.getSystemLocal(config, true);
            }
        }
        return toLocal;
    }

    public static String changeLanLocalWebUrl(Context context, String url) {
        String loadUrl = "";
        if (!TextUtils.isEmpty((CharSequence)url) && url.lastIndexOf(".") > -1) {
            loadUrl = UniversalUtil.getLanguageType(context) == 1 ? url : (UniversalUtil.getLanguageType(context) == 2 ? url.substring(0, url.lastIndexOf(".")) + "-en.html" : url.substring(0, url.lastIndexOf(".")) + "-en.html");
        }
        return loadUrl;
    }

    public static String changeLanServerWebUrl(Context context, String url) {
        String loadUrl = "";
        if (!TextUtils.isEmpty((CharSequence)url) && url.lastIndexOf("/") > -1) {
            loadUrl = UniversalUtil.getLanguageType(context) == 1 ? url : (UniversalUtil.getLanguageType(context) == 2 ? url.substring(0, url.lastIndexOf("/") + 1) + "English" + url.substring(url.lastIndexOf("/"), url.length()) : url.substring(0, url.lastIndexOf("/") + 1) + "English" + url.substring(url.lastIndexOf("/"), url.length()));
        }
        return loadUrl;
    }
}

