/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.share.adapter.BaseShareViewHolder;
import com.xdja.im.lib.share.presenter.ShareSessionListAdapterPresenter;
import com.xdja.im.uikit.R;

public class ShareViewHolder
extends BaseShareViewHolder<ShareSessionListAdapterPresenter, TalkSessionBean> {
    private ImageView imgUserHeader;
    private TextView tvUserName;

    public ShareViewHolder(View itemView, ShareSessionListAdapterPresenter shareSessionListPresenter) {
        super(itemView, shareSessionListPresenter);
        this.imgUserHeader = (ImageView)itemView.findViewById(R.id.img_user_header);
        this.tvUserName = (TextView)itemView.findViewById(R.id.tv_user_name);
    }

    @Override
    public void bind(int position, TalkSessionBean item) {
        if (item != null) {
            this.addListener(item);
            this.updateSessionBaseView(item, IMUiKitProxyImpl.getInstance().getAccount(item.getTalkerAccount(), item.getTalkType()));
        }
    }

    private void addListener(final TalkSessionBean item) {
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ShareSessionListAdapterPresenter)ShareViewHolder.this.getPresenter()).onItemClickListener(item);
            }
        });
    }

    private void updateSessionBaseView(TalkSessionBean item, AccountBean accountBean) {
        if (null == accountBean) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)accountBean.getDisplayName())) {
            this.tvUserName.setText((CharSequence)accountBean.getDisplayName());
        } else {
            this.tvUserName.setText((CharSequence)accountBean.getAccount());
        }
        Drawable avatarDrawable = accountBean.getAvatarDrawable();
        if (avatarDrawable != null) {
            this.imgUserHeader.setImageDrawable(avatarDrawable);
            return;
        }
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (item.getTalkType() == 2) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        String avatarUrl = accountBean.getAvatarUrl();
        Glide.with((Activity)((ShareSessionListAdapterPresenter)this.getPresenter()).getActivity()).load(avatarUrl).placeholder(imgId).error(imgId).bitmapTransform(new Transformation[]{new GlideCircleTransform((Context)((ShareSessionListAdapterPresenter)this.getPresenter()).getActivity())}).into(this.imgUserHeader);
    }
}

