/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;

public class DisplayUtils {
    public static int getWidthPixels(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Configuration cf = context.getResources().getConfiguration();
        int ori = cf.orientation;
        if (ori == 2) {
            return displayMetrics.heightPixels;
        }
        if (ori == 1) {
            return displayMetrics.widthPixels;
        }
        return 0;
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private static int getDpi(Context context) {
        int dpi = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, displayMetrics);
            dpi = displayMetrics.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    public static int getBottomStatusHeight(Context context) {
        int totalHeight = DisplayUtils.getDpi(context);
        int contentHeight = DisplayUtils.getScreenHeight(context);
        return totalHeight - contentHeight;
    }

    private static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }
}

