/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.action.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.lib.filemanage.util.ActomaController;

public class MediaManger {
    private static String TAG = "MediaManger";
    private static final int VERSION = Build.VERSION.SDK_INT;
    private final AudioManager mAudioManager;
    private PowerManager.WakeLock mWakeLock;
    private boolean isWakeAcquire = false;
    private boolean isReceiverMode = false;
    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return this.isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        this.isReceiverMode = receiverMode;
    }

    @SuppressLint(value={"InlinedApi"})
    private MediaManger() {
        Context context = ActomaController.getApp();
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        if (VERSION >= 21) {
            PowerManager pManager = (PowerManager)ActomaController.getApp().getSystemService("power");
            this.mWakeLock = pManager.newWakeLock(32, TAG);
        }
    }

    public static MediaManger getInstance() {
        return SingletonInstance.mInstance;
    }

    public void onSensorChanged(boolean isReceiverMode) {
        if (!AudioPlayerManager.getInstance().isPlaying()) {
            if (this.isWakeAcquire) {
                this.wakeLockBrightRelease();
            }
            return;
        }
        if (isReceiverMode) {
            this.setReceiverModeOn();
        } else {
            this.setReceiverModeOff();
        }
    }

    public void setHeadsetOn(boolean headsetOn) {
        this.isHeadsetOn = headsetOn;
    }

    public boolean isHeadsetOn() {
        return this.isHeadsetOn || this.mAudioManager.isWiredHeadsetOn();
    }

    public void restoreAudioMode() {
        if (!TelphoneState.getPhotoStateIsIdle(ActomaController.getApp())) {
            return;
        }
        this.mAudioManager.setMode(0);
    }

    public void setReceiverModeOn() {
        this.mAudioManager.setMode(3);
        this.mAudioManager.setSpeakerphoneOn(false);
    }

    public void setReceiverModeOff() {
        this.mAudioManager.setMode(0);
    }

    public void wakeLockBrightAcquire() {
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.isWakeAcquire = true;
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire(600000L);
        }
    }

    public void wakeLockBrightRelease() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public boolean isWakeAcquire() {
        return this.isWakeAcquire;
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();

        private SingletonInstance() {
        }
    }
}

