/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.repository.impl.im.IMProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.ui.adapter.FilePreviewAdapter;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.ui.presenter.FilePreviewPresenter;
import com.xdja.im.uikit.ui.view.ViewFilePreview;
import com.xdja.im.uikit.ui.view.vu.FilePreviewVu;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import rx.Subscriber;

public class FilePreviewActivity
extends ImBaseActivity<FilePreviewPresenter, FilePreviewVu>
implements FilePreviewPresenter,
FilePreviewAdapter.SettingMsgIdCallback {
    @Inject
    Lazy<IMProxyImpl> imProxy;
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    @Inject
    ImageLoader imageLoader;
    private String mTalkId;
    private long mMsgId;
    private List<TalkMessageBean> mMessageList = new ArrayList<TalkMessageBean>();
    private FilePreviewAdapter mAdapter;
    private boolean isActivityShowing = false;

    @Override
    @NonNull
    protected Class<? extends FilePreviewVu> getVuClass() {
        return ViewFilePreview.class;
    }

    @Override
    @NonNull
    protected FilePreviewPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setSystemUiVisibility(1536);
        this.getWindow().addFlags(1536);
    }

    @Override
    protected void preBindView(@Nullable Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mTalkId = intent.getStringExtra("talkerId");
            this.mMsgId = intent.getLongExtra("messageId", 0L);
            LogUtil.d("Start preview Image, current msgId :" + this.mMsgId + ", mTalkId:" + this.mTalkId);
        }
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        BusProvider.getInstance().register(this);
        this.mAdapter = new FilePreviewAdapter((Activity)this, this.mMessageList, (IMProxyImpl)this.imProxy.get(), this.imageLoader, this);
        ((FilePreviewVu)this.getVu()).setAdapter(this.mAdapter);
        this.loadFileData();
    }

    private void loadFileData() {
        ((ProxyRepository)this.proxyRepository.get()).getSessionFileList(this.mTalkId, 0, 0, 0, new Subscriber<List<TalkMessageBean>>(){

            public void onCompleted() {
                LogUtil.d("load session file finished.");
                ((FilePreviewVu)FilePreviewActivity.this.getVu()).setProgressVisibility(8);
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: load session error, " + e.getMessage());
            }

            public void onNext(List<TalkMessageBean> talkMessageBeen) {
                FilePreviewActivity.this.mMessageList.clear();
                Collections.reverse(talkMessageBeen);
                FilePreviewActivity.this.mMessageList.addAll(talkMessageBeen);
                FilePreviewActivity.this.mAdapter.notifyDataSetChanged();
                ((FilePreviewVu)FilePreviewActivity.this.getVu()).setCurrentPosition(FilePreviewActivity.this.getCurrentPosition());
            }
        });
    }

    private int getCurrentPosition() {
        int size = this.mMessageList.size();
        for (int i = 0; i < size; ++i) {
            TalkMessageBean bean = this.mMessageList.get(i);
            if (bean == null || bean.getId() != this.mMsgId) continue;
            return i;
        }
        LogUtil.w("Not math the current msgId :" + this.mMsgId);
        return 0;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.imageLoader != null) {
            this.imageLoader.clearMemoryCache((Activity)this);
        }
    }

    private int mathMessage(long messageId) {
        int size = this.mMessageList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (messageId != this.mMessageList.get(i).getId()) continue;
            return i;
        }
        return -1;
    }

    private void updateFileInfo(FileInfo fileInfo, FileInfo eventFile) {
        if (fileInfo.getFileType() == 3) {
            FileInfo rawFileInfo;
            ImageFileInfo eventFileInfo = (ImageFileInfo)eventFile;
            ImageFileInfo imageFileInfo = (ImageFileInfo)fileInfo;
            FileInfo hdFileInfo = eventFileInfo.getHdFileInfo();
            if (hdFileInfo != null) {
                imageFileInfo.getHdFileInfo().setFilePath(hdFileInfo.getFilePath());
                imageFileInfo.getHdFileInfo().setTranslateSize(hdFileInfo.getTranslateSize());
                imageFileInfo.getHdFileInfo().setFileState(hdFileInfo.getFileState());
            }
            if ((rawFileInfo = eventFileInfo.getRawFileInfo()) != null) {
                imageFileInfo.getRawFileInfo().setFilePath(rawFileInfo.getFilePath());
                imageFileInfo.getRawFileInfo().setTranslateSize(rawFileInfo.getTranslateSize());
                imageFileInfo.getRawFileInfo().setFileState(rawFileInfo.getFileState());
            }
        } else if (fileInfo.getFileType() == 2) {
            VideoFileInfo eventFileInfo = (VideoFileInfo)eventFile;
            VideoFileInfo videoFileInfo = (VideoFileInfo)fileInfo;
            FileInfo rawFileInfo = eventFileInfo.getRawFileInfo();
            if (rawFileInfo != null) {
                videoFileInfo.getRawFileInfo().setFilePath(rawFileInfo.getFilePath());
                videoFileInfo.getRawFileInfo().setTranslateSize(rawFileInfo.getTranslateSize());
                videoFileInfo.getRawFileInfo().setFileState(rawFileInfo.getFileState());
            }
        }
    }

    private void updateFileInfo(int position, FileInfo fileInfo) {
        if (position < 0 || position > this.mMessageList.size()) {
            return;
        }
        this.mMessageList.get(position).setFileInfo(fileInfo);
        ((FilePreviewVu)this.getVu()).fileDownloadFinish(position);
    }

    @Subscribe
    public void onReceiveFileFinished(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        LogUtil.d("EVENT: ReceiveFileFinishedEvent.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Receive file completed, position:" + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file completed, but fileInfo is null.");
            return;
        }
        FileInfo eventFile = event.getFileInfo();
        if (eventFile == null) {
            LogUtil.e("ERROR: Receive file completed, but event fileInfo is null.");
            return;
        }
        this.mMessageList.get(position).getFileInfo().setFileState(2);
        this.updateFileInfo(fileInfo, eventFile);
        this.updateFileInfo(position, fileInfo);
    }

    @Subscribe
    public void onReceiveFileProgressUpdate(IMProxyFileEvent.ReceiveFileProgressUpdateEvent event) {
        LogUtil.d("EVENT: onReceiveFileProgressUpdate.");
    }

    @Subscribe
    public void onReceiveFilePaused(IMProxyFileEvent.ReceiveFilePausedEvent event) {
    }

    @Subscribe
    public void onReceiveFileFailed(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        LogUtil.d("EVENT: ReceiveFileFailedEvent.");
        int position = this.mathMessage(event.getAttachedMsgId());
        if (position < 0) {
            LogUtil.e("ERROR: Receive file failed, position:" + position);
            return;
        }
        FileInfo fileInfo = this.mMessageList.get(position).getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: Receive file failed, but fileInfo is null.");
            return;
        }
        FileInfo eventFile = event.getFileInfo();
        if (eventFile == null) {
            LogUtil.e("ERROR: Receive file failed, but event fileInfo is null.");
            return;
        }
        this.mMessageList.get(position).getFileInfo().setFileState(5);
        this.updateFileInfo(fileInfo, eventFile);
        this.updateFileInfo(position, fileInfo);
    }

    @Override
    public void setCurMsgId(long msgId) {
        this.mMsgId = msgId;
    }

    @Override
    public void updateUI() {
        ((FilePreviewVu)this.getVu()).setAdapter(this.mAdapter);
    }

    @Override
    public void showEmptyView() {
        ((FilePreviewVu)this.getVu()).showEmptyView();
    }

    @Override
    public void selectPage(int index, TalkMessageBean bean) {
        if (index > 0) {
            ((FilePreviewVu)this.getVu()).getViewPager().setCurrentItem(index);
        } else if (index == 0) {
            ((FilePreviewVu)this.getVu()).getViewPager().setCurrentItem(index);
        }
        this.deleteItem(bean);
    }

    public void deleteItem(final TalkMessageBean messageBean) {
        if (messageBean != null) {
            final long id2 = messageBean.getId();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(id2);
            ((ProxyRepository)this.proxyRepository.get()).deleteMessages(ids, new Subscriber<Integer>(){

                public void onCompleted() {
                    LogUtil.d("Delete message successfully. " + id2);
                }

                public void onError(Throwable e) {
                    LogUtil.e("delete message error, " + e.getMessage());
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        FilePreviewActivity.this.onDeleteMessage(messageBean);
                    }
                }
            });
        }
    }

    private int onDeleteMessage(TalkMessageBean talkMessageBean) {
        try {
            IMProxyMessageEvent.DeleteMessageEvent messageEvent = new IMProxyMessageEvent.DeleteMessageEvent();
            messageEvent.setMsgAccount(talkMessageBean.getFrom());
            messageEvent.setTalkMessageBean(talkMessageBean);
            BusProvider.getInstance().post(messageEvent);
            return 1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Subscribe
    public void msgRecall(final IMProxyEvent.RecallMessageEvent event) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TalkMessageBean recallMsg = event.getTalkMessageBean();
                if (recallMsg != null && !recallMsg.isMine() && recallMsg.getMessageState() == 7) {
                    long msgId = recallMsg.getId();
                    TalkMessageBean talkMessageBean = FilePreviewActivity.this.getTalkMessageBean(msgId);
                    if (talkMessageBean == null) {
                        return;
                    }
                    if (FilePreviewActivity.this.isActivityShowing) {
                        if (recallMsg.getId() == ((TalkMessageBean)FilePreviewActivity.this.mMessageList.get(FilePreviewActivity.this.getCurrentPosition())).getId()) {
                            FilePreviewActivity.this.pauseVideo(recallMsg, FilePreviewActivity.this.mathMessage(recallMsg.getId()));
                            FilePreviewActivity.this.showDialog(recallMsg);
                        } else {
                            if (FilePreviewActivity.this.mMessageList.contains(talkMessageBean)) {
                                FilePreviewActivity.this.mMessageList.remove(talkMessageBean);
                            }
                            FilePreviewActivity.this.mAdapter.notifyDataSetChanged();
                        }
                    }
                }
            }
        });
    }

    private TalkMessageBean getTalkMessageBean(long id2) {
        TalkMessageBean talkMessageBean = null;
        for (int i = this.mMessageList.size() - 1; i >= 0; --i) {
            if (this.mMessageList.get(i).getId() != id2) continue;
            talkMessageBean = this.mMessageList.get(i);
            talkMessageBean.setMessageState(7);
            break;
        }
        return talkMessageBean;
    }

    protected void onResume() {
        super.onResume();
        this.isActivityShowing = true;
    }

    protected void onPause() {
        super.onPause();
        this.isActivityShowing = false;
    }

    private void pauseVideo(TalkMessageBean talkMessageBean, int id2) {
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo != null && fileInfo instanceof VideoFileInfo) {
            this.mAdapter.onPause(id2);
        }
    }

    private void showDialog(TalkMessageBean bean) {
        new CustomDialog((Context)this, new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                FilePreviewActivity.this.finish();
            }
        }).setIfShowNegative(false).setDialogTitle(R.string.im_uikit_hint).setDialogContent(bean.getContent()).setPositiveButton(R.string.im_uikit_ok_text).setCancel(false).show();
    }
}

