/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.view.ViewSessionItem;
import com.xdja.im.uikit.utils.AtPreferencesUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ViewGroupItem
extends ViewSessionItem {
    public static final String SEPARATOR = ": ";
    private String at = "at";
    private TextView senderName;
    private TextView senderNameSeparator;
    private TextView atRemind;
    private ImageView img_meeting_flag;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (null != view) {
            this.senderName = (TextView)view.findViewById(R.id.tv_senderName);
            this.senderNameSeparator = (TextView)view.findViewById(R.id.tv_senderNameSeparate);
            this.atRemind = (TextView)view.findViewById(R.id.at_remind);
            this.img_meeting_flag = (ImageView)view.findViewById(R.id.img_meeting_flag);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.updateSessionSenderInfo();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
    }

    @Override
    protected CharSequence getContent(String displayName) {
        if (((TalkSessionBean)this.dataSource).getLastMsg() != null && ((TalkSessionBean)this.dataSource).getLastMsg().isMine()) {
            this.senderName.setVisibility(8);
            this.senderNameSeparator.setVisibility(8);
            return this.getMessageContent();
        }
        this.senderName.setVisibility(0);
        this.senderName.setText((CharSequence)displayName);
        this.senderNameSeparator.setVisibility(0);
        return this.getMessageContent();
    }

    private CharSequence getMessageContent() {
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > talkMessageBean.getShowTime()) {
            CharSequence content = this.formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content, (Context)this.getActivity(), 0.8f);
        }
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        switch (messageType) {
            case 0: 
            case 14: {
                return EmotionUtils.formatSpanContent(((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity(), 0.8f);
            }
            case 1: {
                return this.getStringRes(R.string.im_uikit_voice);
            }
            case 2: {
                return this.getStringRes(R.string.im_uikit_video);
            }
            case 3: {
                return this.getStringRes(R.string.im_uikit_image);
            }
            case 4: {
                return this.getStringRes(R.string.im_uikit_file);
            }
            case 5: {
                return this.getStringRes(R.string.im_uikit_web_message);
            }
            case 102: {
                return this.getCustomStr(talkMessageBean);
            }
        }
        return ((TalkSessionBean)this.dataSource).getContent() == null ? "" : ((TalkSessionBean)this.dataSource).getContent();
    }

    private void updateSessionSenderInfo() {
        this.atRemind.setVisibility(8);
        this.img_meeting_flag.setVisibility(8);
        if (this.dataSource != null && ((TalkSessionBean)this.dataSource).getLastMsg() != null && ((TalkSessionBean)this.dataSource).getLastMsg().getMessageType() != 101 && this.isCanAtRemid()) {
            this.atRemind.setVisibility(0);
            this.atRemind.setText(this.formatAtRemind());
        }
        Observable.just((Object)(this.dataSource != null ? ((TalkSessionBean)this.dataSource).getTalkFlag() : "")).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, MeetInfo>(){

            public MeetInfo call(String s) {
                return MeetInfoEntityDao.getInstance().get(s);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<MeetInfo>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
            }

            public void onNext(MeetInfo mMeetInfo) {
                if (mMeetInfo != null && mMeetInfo.getIsShow() == 1 && mMeetInfo.getTaklFlag().equals(((TalkSessionBean)ViewGroupItem.this.dataSource).getTalkFlag())) {
                    ViewGroupItem.this.img_meeting_flag.setVisibility(0);
                } else {
                    ViewGroupItem.this.img_meeting_flag.setVisibility(8);
                }
            }
        });
        if (null != ((TalkSessionBean)this.dataSource).getLastMsgAccount() && !((TalkSessionBean)this.dataSource).getLastMsg().isMine() && ((TalkSessionBean)this.dataSource).getLastMsgType() != 101) {
            if (((TalkSessionBean)this.dataSource).getParam() != null && !TextUtils.isEmpty((CharSequence)((TalkSessionBean)this.dataSource).getParam().getDraftContent()) && ((TalkSessionBean)this.dataSource).getParam().getDraftTime() > 0L) {
                this.senderName.setVisibility(8);
                this.senderNameSeparator.setVisibility(8);
            } else {
                this.senderName.setVisibility(0);
                this.senderNameSeparator.setVisibility(0);
                this.updateSenderView(IMUiKitProxyImpl.getInstance().getAccount(((TalkSessionBean)this.dataSource).getLastMsgAccount(), 1));
            }
        } else {
            this.senderName.setVisibility(8);
            this.senderNameSeparator.setVisibility(8);
        }
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null == accountBean) {
            return;
        }
        this.senderName.setText((CharSequence)accountBean.getDisplayName());
    }

    private boolean isCanAtRemid() {
        return AtPreferencesUtils.getWrapper((Context)this.getActivity(), this.at).gPrefBooleanValue(((TalkSessionBean)this.dataSource).getTalkerAccount(), false) != false;
    }

    private CharSequence formatAtRemind() {
        String str = "<font color=\"" + this.getActivity().getString(R.string.im_uikit_at_text_color) + "\">" + this.getActivity().getString(R.string.im_uikit_at_have_people_remind) + "</font>";
        return Html.fromHtml((String)str);
    }
}

