/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.GifImageView;

public class ViewSendImageItem
extends BaseSendItem {
    private static final int MAX_PLAY_GIF = 0x300000;
    private ChatImageView mChatImage;
    private GifImageView mGifImageView;
    private ImageView mBombFlagImg;
    private ProgressBar progressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_send_image);
        this.mGifImageView = (GifImageView)this.findViewById(R.id.img_send_gif_image);
        this.mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);
        this.progressBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FileUtils.isFileExists(((TalkMessageBean)ViewSendImageItem.this.dataSource).getFileInfo().getFilePath())) {
                    ((ChatListAdapterPresenter)ViewSendImageItem.this.getPresenter()).previewImage((TalkMessageBean)ViewSendImageItem.this.dataSource);
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }
        this.loadImage(fileInfo, dataSource);
        if (dataSource.isBomb()) {
            this.mBombFlagImg.setVisibility(0);
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            if (imageFileInfo.getFileSize() == FileUtils.getFileLength(imageFileInfo.getFilePath())) {
                this.imageSynchronousAccept(false);
                this.loadImageUrl(imageFileInfo, dataSource);
                LogUtil.d("createScaledBitmap ViewSendImageItem state " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId());
            }
            LogUtil.d("createScaledBitmap ViewSendImageItem size  msgId : " + dataSource.getId());
        } else if (this.showDefaultImageMessageState(imageFileInfo, dataSource)) {
            LogUtil.w("file is not exit.");
            this.imageSynchronousAccept(false);
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
            LogUtil.d("createScaledBitmap ViewSendImageItem state1 " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId());
        } else {
            this.imageSynchronousAccept(true);
            ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile(dataSource, imageFileInfo);
            LogUtil.d("createScaledBitmap ViewSendImageItem state2 " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId());
        }
    }

    private boolean showDefaultImageMessageState(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        return imageFileInfo.getFileState() == 2 || imageFileInfo.getFileState() == 5 || dataSource.getMessageState() == 0 || dataSource.getMessageState() == 1;
    }

    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        if (imageFileInfo != null && "gif".equalsIgnoreCase(suffix) && !TextUtils.isEmpty((CharSequence)imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(0);
            this.mGifImageView.loadImageFrame(urlGif);
            if (dataSource.isGifPlayed()) {
                this.mGifImageView.stopAnimation();
            } else if (HistoryFileUtils.isFileExist(urlGif) && fileSize < 0x300000L) {
                this.mGifImageView.loadImage(urlGif);
            }
        } else {
            this.mChatImage.setVisibility(0);
            this.mGifImageView.setVisibility(8);
            this.mChatImage.loadImage(imageFileInfo.getFilePath(), 1);
        }
    }

    private void imageSynchronousAccept(boolean accept) {
        if (accept) {
            this.progressBar.setVisibility(0);
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(8);
        } else {
            this.progressBar.setVisibility(8);
            this.mChatImage.setVisibility(0);
            this.mGifImageView.setVisibility(0);
        }
    }
}

