/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class DataConvertUtils {
    public static FileInfo mapImageFileInfo(ImageThumbBean thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty((CharSequence)thumbBean.getThumbPath()) || TextUtils.isEmpty((CharSequence)thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is empty or hd thumb path is null.");
            return null;
        }
        FileInfo gifThumbFile = new FileInfo();
        gifThumbFile.setFileName(thumbBean.getThumbName());
        gifThumbFile.setFilePath(thumbBean.getThumbPath());
        gifThumbFile.setFileSize(thumbBean.getThumbSize());
        imageFileInfo.setGifFileInfo(gifThumbFile);
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        if (!TextUtils.isEmpty((CharSequence)thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
            String suffix = ToolUtil.getLastString(thumbBean.getRawPath(), ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                rawFileInfo.setSuffix(suffix);
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getRawPath());
            imageFileInfo.setFileName(thumbBean.getRawName());
            imageFileInfo.setFileSize(thumbBean.getRawSize());
        } else {
            imageFileInfo.setOriginal(false);
            String suffix = ToolUtil.getLastString(thumbBean.getHdThumbPath(), ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getHdThumbPath());
            imageFileInfo.setFileName(thumbBean.getHdThumbPath());
            imageFileInfo.setFileSize(thumbBean.getHdThumbSize());
        }
        return imageFileInfo;
    }

    public static ImageFileInfo mapImagePicFileInfo(FileInfo thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty((CharSequence)thumbBean.getFilePath())) {
            LogUtil.e("ERROR:thumb path is empty or hd thumb path is null.");
            return null;
        }
        FileInfo gifThumbFile = new FileInfo();
        gifThumbFile.setFileName(thumbBean.getFileName());
        gifThumbFile.setFilePath(thumbBean.getFilePath());
        gifThumbFile.setFileSize(thumbBean.getFileSize());
        imageFileInfo.setGifFileInfo(gifThumbFile);
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getFileName());
        hdThumbFile.setFilePath(thumbBean.getFilePath());
        hdThumbFile.setFileSize(thumbBean.getFileSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        imageFileInfo.setFileType(thumbBean.getFileType());
        if (!TextUtils.isEmpty((CharSequence)thumbBean.getFilePath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getFileName());
            rawFileInfo.setFilePath(thumbBean.getFilePath());
            rawFileInfo.setFileSize(thumbBean.getFileSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
            String suffix = ToolUtil.getLastString(thumbBean.getFilePath(), ".");
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                rawFileInfo.setSuffix(suffix);
                imageFileInfo.setSuffix(suffix);
            }
            imageFileInfo.setFilePath(thumbBean.getFilePath());
            imageFileInfo.setFileName(thumbBean.getFileName());
            imageFileInfo.setFileSize(thumbBean.getFileSize());
        }
        return imageFileInfo;
    }

    public static FileInfo mapVideoFileInfo(VideoItem videoItem) {
        if (TextUtils.isEmpty((CharSequence)videoItem.getFilePath()) || TextUtils.isEmpty((CharSequence)videoItem.getRawFilePath())) {
            LogUtil.e("ERROR: video file path is null.");
            return null;
        }
        VideoFileInfo videoFileInfo = new VideoFileInfo();
        videoFileInfo.setFileName(videoItem.getFileName());
        videoFileInfo.setFilePath(videoItem.getFilePath());
        videoFileInfo.setFileSize(videoItem.getFileSize());
        FileInfo rawFileInfo = new FileInfo();
        rawFileInfo.setFileName(videoItem.getRawFileName());
        rawFileInfo.setFilePath(videoItem.getRawFilePath());
        rawFileInfo.setFileSize(videoItem.getRawFileSize());
        videoFileInfo.setRawFileInfo(rawFileInfo);
        videoFileInfo.setAmountOfTime(videoItem.getDuration());
        videoFileInfo.setRawFileSize(videoItem.getRawFileSize());
        return videoFileInfo;
    }

    public static FileInfo mapVideoFileInfo(FileInfo videoItem) {
        if (TextUtils.isEmpty((CharSequence)videoItem.getFilePath())) {
            LogUtil.e("ERROR: video file path is null.");
            return null;
        }
        File firstFrame = DataConvertUtils.saveFirstFrame(videoItem.getFilePath());
        if (firstFrame == null) {
            return null;
        }
        String suffix = ToolUtil.getLastString(videoItem.getFileName(), ".");
        int duration = IMFileUtils.getVideoDuration(videoItem.getFilePath());
        VideoFileInfo videoFileInfo = new VideoFileInfo();
        videoFileInfo.setAmountOfTime(duration / 1000);
        videoFileInfo.setFilePath(firstFrame.getPath());
        videoFileInfo.setFileName(firstFrame.getName());
        videoFileInfo.setSuffix(suffix);
        videoFileInfo.setFileType(2);
        videoFileInfo.setFileSize(firstFrame.length());
        videoFileInfo.setRawFileSize(videoItem.getFileSize());
        FileInfo extraInfo = new FileInfo();
        extraInfo.setFilePath(videoItem.getFilePath());
        extraInfo.setFileName(videoItem.getFileName());
        extraInfo.setFileSize(videoItem.getFileSize());
        extraInfo.setSuffix(suffix);
        extraInfo.setFileType(2);
        videoFileInfo.setRawFileInfo(extraInfo);
        return videoFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveFirstFrame(String path) {
        MediaMetadataRetriever media = null;
        try {
            media = new MediaMetadataRetriever();
            media.setDataSource(path);
        }
        catch (RuntimeException e) {
            LogUtil.d("share file", "\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
            new XToast(ActomaController.getAppConfigContext()).display(R.string.im_uikit_file_exception);
        }
        catch (Exception e) {
            LogUtil.d("share file", "\u4fdd\u5b58\u77ed\u89c6\u9891\u7b2c\u4e00\u5e27\u5931\u8d25\uff0c\u77ed\u89c6\u9891\u8def\u5f84\u9519\u8bef");
        }
        if (media == null) {
            return null;
        }
        Bitmap bitmap = media.getFrameAtTime(0L);
        String fileName = UUID.randomUUID().toString();
        BufferedOutputStream bos = null;
        File firstFrameFile = new File(ToolUtil.getVideoPath(), fileName);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(firstFrameFile));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 20, (OutputStream)bos);
        }
        catch (Exception e) {
            LogUtil.e("share file", "Get video first frame fail");
            File file = null;
            return file;
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return firstFrameFile;
    }

    public static FileInfo mapPhotoFileInfo(PhotoThumbBean thumbBean) {
        ImageFileInfo imageFileInfo = new ImageFileInfo();
        if (TextUtils.isEmpty((CharSequence)thumbBean.getThumbPath()) || TextUtils.isEmpty((CharSequence)thumbBean.getHdThumbPath())) {
            LogUtil.e("ERROR:thumb path is im_uikit_empty or hd thumb path is null.");
            return null;
        }
        imageFileInfo.setFileName(thumbBean.getThumbName());
        imageFileInfo.setFilePath(thumbBean.getThumbPath());
        imageFileInfo.setFileSize(thumbBean.getThumbSize());
        FileInfo hdThumbFile = new FileInfo();
        hdThumbFile.setFileName(thumbBean.getHdThumbName());
        hdThumbFile.setFilePath(thumbBean.getHdThumbPath());
        hdThumbFile.setFileSize(thumbBean.getHdThumbSize());
        imageFileInfo.setHdFileInfo(hdThumbFile);
        if (!TextUtils.isEmpty((CharSequence)thumbBean.getRawPath())) {
            FileInfo rawFileInfo = new FileInfo();
            rawFileInfo.setFileName(thumbBean.getRawName());
            rawFileInfo.setFilePath(thumbBean.getRawPath());
            rawFileInfo.setFileSize(thumbBean.getRawSize());
            imageFileInfo.setRawFileInfo(rawFileInfo);
            imageFileInfo.setOriginal(true);
        }
        return imageFileInfo;
    }

    public static FileInfo mapFileInfo(FileItem fileItem) {
        if (TextUtils.isEmpty((CharSequence)fileItem.getFilePath())) {
            LogUtil.e("ERROR: file path is null.");
            return null;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(fileItem.getFileName());
        fileInfo.setFilePath(fileItem.getFilePath());
        fileInfo.setFileSize(fileItem.getFileSize());
        String suffix = ToolUtil.getLastString(fileItem.getFileName(), ".");
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            fileInfo.setSuffix(suffix);
        }
        return fileInfo;
    }
}

