/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.log;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.im.uikit.utils.log.klog.BaseLog;
import com.xdja.im.uikit.utils.log.klog.FileLog;
import com.xdja.im.uikit.utils.log.klog.JsonLog;
import com.xdja.im.uikit.utils.log.klog.XmlLog;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class LogUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NULL_TIPS = "Log with null object";
    private static final String DEFAULT_MESSAGE = "execute";
    private static final String PARAM = "Param";
    private static final String NULL = "null";
    private static final String TAG_DEFAULT = "LogUtil";
    private static final String SUFFIX = ".java";
    public static final int JSON_INDENT = 4;
    public static final int V = 1;
    public static final int D = 2;
    public static final int I = 3;
    public static final int W = 4;
    public static final int E = 5;
    public static final int A = 6;
    private static final int JSON = 7;
    private static final int XML = 8;
    private static final int STACK_TRACE_INDEX_5 = 5;
    private static final int STACK_TRACE_INDEX_4 = 4;
    private static String mGlobalTag;
    private static boolean mIsGlobalTagEmpty;
    private static boolean IS_SHOW_LOG;

    public static void init(boolean isShowLog) {
        IS_SHOW_LOG = isShowLog;
    }

    public static void init(boolean isShowLog, @Nullable String tag) {
        IS_SHOW_LOG = isShowLog;
        mGlobalTag = tag;
        mIsGlobalTagEmpty = TextUtils.isEmpty((CharSequence)mGlobalTag);
    }

    public static void v() {
        LogUtil.printLog(1, null, DEFAULT_MESSAGE);
    }

    public static void v(Object msg) {
        LogUtil.printLog(1, null, msg);
    }

    public static void v(String tag, Object ... objects) {
        LogUtil.printLog(1, tag, objects);
    }

    public static void d() {
        LogUtil.printLog(2, null, DEFAULT_MESSAGE);
    }

    public static void d(Object msg) {
        LogUtil.printLog(2, null, msg);
    }

    public static void d(String tag, Object ... objects) {
        LogUtil.printLog(2, tag, objects);
    }

    public static void i() {
        LogUtil.printLog(3, null, DEFAULT_MESSAGE);
    }

    public static void i(Object msg) {
        LogUtil.printLog(3, null, msg);
    }

    public static void i(String tag, Object ... objects) {
        LogUtil.printLog(3, tag, objects);
    }

    public static void w() {
        LogUtil.printLog(4, null, DEFAULT_MESSAGE);
    }

    public static void w(Object msg) {
        LogUtil.printLog(4, null, msg);
    }

    public static void w(String tag, Object ... objects) {
        LogUtil.printLog(4, tag, objects);
    }

    public static void e() {
        LogUtil.printLog(5, null, DEFAULT_MESSAGE);
    }

    public static void e(Object msg) {
        LogUtil.printLog(5, null, msg);
    }

    public static void e(String tag, Object ... objects) {
        LogUtil.printLog(5, tag, objects);
    }

    public static void a() {
        LogUtil.printLog(6, null, DEFAULT_MESSAGE);
    }

    public static void a(Object msg) {
        LogUtil.printLog(6, null, msg);
    }

    public static void a(String tag, Object ... objects) {
        LogUtil.printLog(6, tag, objects);
    }

    public static void json(String jsonFormat) {
        LogUtil.printLog(7, null, jsonFormat);
    }

    public static void json(String tag, String jsonFormat) {
        LogUtil.printLog(7, tag, jsonFormat);
    }

    public static void xml(String xml) {
        LogUtil.printLog(8, null, xml);
    }

    public static void xml(String tag, String xml) {
        LogUtil.printLog(8, tag, xml);
    }

    public static void file(File targetDirectory, Object msg) {
        LogUtil.printFile(null, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, Object msg) {
        LogUtil.printFile(tag, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, String fileName, Object msg) {
        LogUtil.printFile(tag, targetDirectory, fileName, msg);
    }

    public static void debug() {
        LogUtil.printDebug(null, DEFAULT_MESSAGE);
    }

    public static void debug(Object msg) {
        LogUtil.printDebug(null, msg);
    }

    public static void debug(String tag, Object ... objects) {
        LogUtil.printDebug(tag, objects);
    }

    public static void trace() {
        LogUtil.printStackTrace();
    }

    private static void printStackTrace() {
        if (!IS_SHOW_LOG) {
            return;
        }
        Throwable tr = new Throwable();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        String message = sw.toString();
        String[] traceString = message.split("\\n\\t");
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (String trace : traceString) {
            if (trace.contains("at com.socks.library.LogUtil")) continue;
            sb.append(trace).append("\n");
        }
        String[] contents = LogUtil.wrapperContent(4, null, sb.toString());
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        BaseLog.printDefault(2, tag, headString + msg);
    }

    private static void printLog(int type, String tagStr, Object ... objects) {
        if (!IS_SHOW_LOG) {
            return;
        }
        String[] contents = LogUtil.wrapperContent(5, tagStr, objects);
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BaseLog.printDefault(type, tag, headString + msg);
                break;
            }
            case 7: {
                JsonLog.printJson(tag, msg, headString);
                break;
            }
            case 8: {
                XmlLog.printXml(tag, msg, headString);
            }
        }
    }

    private static void printDebug(String tagStr, Object ... objects) {
        if (!IS_SHOW_LOG) {
            return;
        }
        String[] contents = LogUtil.wrapperContent(5, tagStr, objects);
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        BaseLog.printDefault(2, tag, headString + msg);
    }

    private static void printFile(String tagStr, File targetDirectory, String fileName, Object objectMsg) {
        if (!IS_SHOW_LOG) {
            return;
        }
        String[] contents = LogUtil.wrapperContent(5, tagStr, objectMsg);
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        FileLog.printFile(tag, targetDirectory, fileName, headString, msg);
    }

    private static String[] wrapperContent(int stackTraceIndex, String tagStr, Object ... objects) {
        String tag;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement targetElement = stackTrace[stackTraceIndex];
        String className = targetElement.getClassName();
        String[] classNameInfo = className.split("\\.");
        if (classNameInfo.length > 0) {
            className = classNameInfo[classNameInfo.length - 1] + SUFFIX;
        }
        if (className.contains("$")) {
            className = className.split("\\$")[0] + SUFFIX;
        }
        String methodName = targetElement.getMethodName();
        int lineNumber = targetElement.getLineNumber();
        if (lineNumber < 0) {
            lineNumber = 0;
        }
        String string2 = tag = tagStr == null ? className : tagStr;
        if (mIsGlobalTagEmpty && TextUtils.isEmpty((CharSequence)tag)) {
            tag = TAG_DEFAULT;
        } else if (!mIsGlobalTagEmpty) {
            tag = mGlobalTag;
        }
        String msg = objects == null ? NULL_TIPS : LogUtil.getObjectsString(objects);
        String headString = "[ (" + className + ":" + lineNumber + ")#" + methodName + " ] ";
        return new String[]{tag, msg, headString};
    }

    private static String getObjectsString(Object ... objects) {
        if (objects.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (object == null) {
                    stringBuilder.append(PARAM).append("[").append(i).append("]").append(" = ").append(NULL).append("\n");
                    continue;
                }
                stringBuilder.append(PARAM).append("[").append(i).append("]").append(" = ").append(object.toString()).append("\n");
            }
            return stringBuilder.toString();
        }
        Object object = objects[0];
        return object == null ? NULL : object.toString();
    }

    static {
        mIsGlobalTagEmpty = true;
        IS_SHOW_LOG = false;
    }
}

