/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.uikit.R;

public class CircleImageView
extends AppCompatImageView {
    @DrawableRes
    private int mDefaultImage = R.mipmap.im_uikit_user_header_40dp;

    public CircleImageView(Context context) {
        super(context);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public <T> void loadImage(@NonNull T drawable2, boolean isNeedFit, int defaultImage) {
        this.mDefaultImage = defaultImage;
        this.loadImage(drawable2, isNeedFit);
    }

    public <T> void loadImage(@NonNull T drawable2, boolean isNeedFit) {
        this.loadImage(drawable2, isNeedFit, true, (ImageView)this, true);
    }

    public <T> void loadImage(@NonNull T drawable2, boolean isNeedFit, boolean showDefaultImage) {
        this.loadImage(drawable2, isNeedFit, true, (ImageView)this, showDefaultImage);
    }

    private <T> void loadImage(@NonNull T drawable2, boolean isNeedFit, boolean isCircle, ImageView imageView, boolean showDefaultImage) {
        RequestManager requestManager = Glide.with((Context)this.getContext().getApplicationContext());
        DrawableTypeRequest builder = drawable2 == null || "".equals(drawable2) ? requestManager.load(Integer.valueOf(this.mDefaultImage)) : requestManager.load((String)drawable2);
        if (isNeedFit) {
            builder = builder.fitCenter();
        }
        builder.crossFade();
        if (showDefaultImage) {
            builder.placeholder(this.mDefaultImage);
        }
        builder.error(this.mDefaultImage);
        if (isCircle) {
            builder.transform(new BitmapTransformation[]{new GlideCircleTransform(this.getContext())});
        }
        builder.into(imageView);
    }

    public void setImageBitmap(Bitmap bm) {
        this.post(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void setBackground(Drawable background) {
    }
}

