package com.xdja.im.base.frame;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

/**
 * @Package: com.xdja.im.base.frame
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:00
 * @Version V1.0
 * @Comment:MVP模式中View层的通用接口
 */
public interface BaseView<P extends Presenter> {
    /**
     * 初始化View
     *
     * @param inflater  布局加载对象
     * @param container View容器
     */
    void init(LayoutInflater inflater, ViewGroup container);

    /**
     * 获取View层整体对象
     *
     * @return
     */
    View getView();

    /**
     * 设置View操作Presenter的接口
     *
     * @param presenter 目标接口
     */
    void setPresenter(P presenter);

    /**
     * 设置和View相关的Activity
     *
     * @param activity 目标Activity
     * @param <A>
     */
    <A extends Activity> void setActivity(A activity);
}
