package com.xdja.im.common.database.builder;

/**
 * @Package: com.xdja.im.common.database.builder
 * @Author: xdjaxa
 * @Creation: 2017-05-22 17:51
 * @Version V1.0
 * @Description:
 */
public class MeetInfoEntityBuilder {

    public static final String TABLE_NAME = "t_meetinfo";


    public static final String ID = "_id";                          // 数据库id
    public static final String MEETINFO_ISSHOW = "isShow";        // 云会议是否展示 0 不展示 1 展示
    public static final String MEETINFO_FLAG = "taklFlag";        // 会话置顶
    public static final String MEETINFO_TIPS = "tips";  // 会话免打扰

    private static final String[] ALL_COLUMNS = {ID, MEETINFO_ISSHOW, MEETINFO_FLAG,
            MEETINFO_TIPS};

    public static final String SQL_CREATE_TABLE_MEETINFO_ENTRY =
            "CREATE TABLE " + TABLE_NAME + " ("
                    + ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
                    + MEETINFO_ISSHOW + " INTEGER DEFAULT 0,"
                    + MEETINFO_FLAG + " TEXT NOT NULL,"
                    + MEETINFO_TIPS + " TEXT NOT NULL)";

    /**
     * 插入
     * INSERT OR REPLACE INTO MEETINFO_entry (...) VALUES(...);
     *
     * @return sql
     */
    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR REPLACE INTO ",
                TABLE_NAME, ALL_COLUMNS);
    }

    public static String delSql(String taklFlag) {
        return SqlBuilder.deleteSql(TABLE_NAME, MEETINFO_FLAG, taklFlag);
    }

    public static String delAllSql() {
        return SqlBuilder.deleteAll(TABLE_NAME);
    }

    public static String querySql(String taklFlag) {
        StringBuilder builder = new StringBuilder("SELECT * FROM ");
        builder.append(TABLE_NAME);
        builder.append(" WHERE ").append(TABLE_NAME).append(".").
                append(MEETINFO_FLAG).append(" = '").append(taklFlag).append("'");
        return builder.toString();
    }

    public static String queryAll() {
        return SqlBuilder.selectAll(TABLE_NAME);
    }
}
