package com.xdja.im.core.proxy;

import android.app.Activity;

import com.xdja.im.core.callback.ClearSessionDataCallback;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkCustomBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkNotifyBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.share.model.ShareBean;

import java.util.List;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-05-26 15:00
 * @Version V1.0
 * @Description:
 */
public interface ModuleProxy {

    /**
     * Im和Mx初始化工作
     */
    void initIMProxy();

    /**
     * 释放资源
     */
    void releaseProxy();

    /**
     * 发送一条文本通知消息到聊天界面
     *
     * @param sessionId
     * @param sessionType
     * @param bean
     */
    void sendNotifyMessage(String sessionId, int sessionType, TalkNotifyBean bean);

    /**
     * 发送一条文本自定义消息到聊天界面
     *
     * @param sessionId
     * @param sessionType
     * @param bean
     */
    void sendCustomTextMessage(String sessionId, int sessionType, TalkCustomBean bean);

    /**
     * 清除会话列表消息
     *
     * @param sessionId 会话ID
     * @param chatType  会话类型
     */
    void clearSessionData(String sessionId, int chatType);

    /**
     * 清除数据操作回掉
     */
    void clearSessionData(String sessionId, int chatType, ClearSessionDataCallback callback);
    /**
     * 清除所有消息
     */
    void clearAllSessionData();

    /**
     * 清除缓存数据
     */
    void clearCacheData();

    /**
     * 设置免打扰模式
     *
     * @param sessionId
     * @param sessionType
     * @param isDisturb
     */
    void setNoDisturbMode(String sessionId, int sessionType, boolean isDisturb);

    /**
     * 会话置顶设置
     *
     * @param sessionId
     * @param sessionType
     */
    void setSessionTop(String sessionId, int sessionType, boolean isTop);

    /**
     * 设置听筒模式
     *
     * @param isOpen 是否开听筒模式
     */
    void setReceiveMode(String sessionId, int sessionType, boolean isOpen);

    /**
     * 获取回话配置信息
     *
     * @param sessionId
     * @param sessionType
     * @return
     */
    SessionParam getSessionParam(String sessionId, int sessionType);

    /**
     * 通知事件
     *
     * @param sessionBean 会话信息
     * @param newMsgCnt   通知消息数
     * @param isDisturb   是否免打扰
     */
    void notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb, List<TalkMessageBean> talkMessageBeen);

    /**
     * 通知会议事件
     *
     * @param meetInfo   是否显示提示信息等
     */
    void notifyMeet(MeetInfo meetInfo );

    /**
     * 分享联系人信息
     * list
     */
    void sendShareInfo(int type ,List<ShareBean> list);

    /**
     * @param activity activity
     * @param content  第三方转发内容
     */
    void forwardThirdContent(Activity activity, String content);

    /**
     * @param talkMessageBean  第三方消息内容
     */
    void deleteThirdContent(TalkMessageBean talkMessageBean);
}
