package com.xdja.im.lib.historyfile.util;

import android.support.annotation.Nullable;
import android.util.Log;

import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.lib.filemanage.server.PreferencesServer;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.util.HmacSHA1Util;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Created by ALH on 2018/5/4.
 * 用于控制文件上传下载的控制器
 */

public final class FilesController {
    /**
     * 文件名最大长度
     */
    private static final int MAX_FILE_NAME_LENGTH = 128;

    private FilesController() {

    }

    private static class FilesControllerHolder {
        private static FilesController sInstance = new FilesController();
    }

    public static synchronized final FilesController getInstance() {
        return FilesControllerHolder.sInstance;
    }

    /**
     * 获取文件后缀名
     *
     * @param fileName 文件名
     * @return 文件后缀名，null - 如果文件不包含后缀名
     */
    @Nullable
    public static String getSuffix(String fileName) {
        int index = fileName.lastIndexOf('.');
        if (index == -1) {
            return null;
        }
        return fileName.substring(index);
    }

    /**
     * 该方法和SignInterceptor2拦截器的功能一样.
     * 提供给其他有需要的模块调用,如果只是想上传文件,可以直接调用uploadFile
     *
     * @param type   签名类型
     * @param fileId 文件标识
     * @return 签名结果（0：签名，1：过期时间戳，2：用户ID）
     * @throws JSONException
     * @throws IOException
     */
    public String[] requestSign(UserCache userCache, String type, String fileId) throws JSONException, IOException {
        String url = userCache.get().getFastDfsAddr();
        if (!url.endsWith("/")) url = url + File.separator;
        Request request = new Request.Builder()
                .url(url + OkHttpConstants.URL_TIME)
                .build();
        // Modified by guting on 2018/5/17: 返回解析之后的签名信息
        Response response = ImUiKit.getInstance().getComponent().okHttpsClient().newCall(request)
                .execute();
        String[] signResults = null;
        if (response.isSuccessful()) {
            signResults = new String[3];
            try {
                long timestramp = 0;
                String result = response.body().string();
                LogUtil.d("result:  " + result);
                JSONObject jsonObject = new JSONObject(result);
                if (jsonObject.has("timestamp")) {
                    timestramp = jsonObject.getLong("timestamp");
                }
                timestramp = timestramp + 20 * 60 * 1000;
                String data = "";
                if (type.equals(ImSdkFileConstant.SIGN_TYPE_UPLOAD)) {//userid
                    data = userCache.get().getFastUserId() + timestramp;
                } else if (type.equals(ImSdkFileConstant.SIGN_TYPE_INFO)) {//  /info/+fileId
                    data = "/info/" + fileId + timestramp;
                } else if (type.equals(ImSdkFileConstant.SIGN_TYPE_DOWNLOAD)) {// fileId
                    data = fileId + timestramp;
                } else if (type.equals(ImSdkFileConstant.SIGN_TYPE_DELETE)) {// /delete/+fileId
                    data = "/delete/" + fileId + timestramp;
                }
                String sign = HmacSHA1Util.hamcsha1(data, userCache.get().getFastUserSecret());
                signResults[0] = sign;
                signResults[1] = String.valueOf(timestramp);
                signResults[2] = userCache.get().getFastUserId();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return signResults;
    }

}
