package com.xdja.im.lib.share.adapter;

import android.app.Activity;
import android.view.View;

import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.share.presenter.ShareSessionListAdapterPresenter;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.uikit.R;

import java.util.List;

/**
 * @Package: com.xdja.im.uikit.presenter.adapter
 * @Author: xdjaxa
 * @Date: 2017-04-10 18:00
 * @Version V1.0
 * @Comment: 会话列表适配器
 */
public class ShareSessionListAdapter  extends BaseShareSessionAdapterPresenter<ShareSessionListAdapterPresenter,TalkSessionBean> implements ShareSessionListAdapterPresenter{

    private ShareSessionListPresenter shareSessionListPresenter;
    private List<TalkSessionBean> list;

    public ShareSessionListAdapter(List<TalkSessionBean> list,ShareSessionListPresenter shareSessionListPresenter) {
        this.list = list;
        this.shareSessionListPresenter = shareSessionListPresenter;
    }

    @Override
    public ShareSessionListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    public TalkSessionBean getItemData(int position) {
        return list == null ? null : list.get(position);
    }

    @Override
    public int getItemSize() {
        return list == null ? 0 : list.size();
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    @Override
    protected int getItemLayoutRes(int viewType) {
        return R.layout.im_uikit_share_session_list_item_layout;
    }

    @Override
    BaseShareViewHolder getViewHolder(int viewType,View view) {
        return new ShareViewHolder(view,getPresenter());
    }

//    /**
//     * 获取联系人信息
//     *
//     * @param account  联系人账号
//     * @param talkType 会话类型
//     * @return 联系人信息
//     */
//    @Override
//    public AccountBean getAccount(String account, int talkType) {
//        return IMUiKitProxyImpl.getInstance().getAccount(account, talkType);
//    }

    @Override
    public Activity getActivity() {
        return shareSessionListPresenter.getActivity();
    }

    @Override
    public void onItemClickListener(TalkSessionBean item) {
        shareSessionListPresenter.onListItemClick(item);
    }
}
