package com.xdja.im.lib.video.ui.view.vu;

import com.xdja.im.base.frame.view.ActivityBaseView;
import com.xdja.im.lib.video.manager.VideoManager;
import com.xdja.im.lib.video.ui.presenter.VideoRecorderPresenter;

/**
 * @Package: com.xdja.im.lib.video.ui.view.vu
 * @Author: xdjaxa
 * @Creation: 2017-04-24 9:15
 * @Version V1.0
 * @Description:
 */
public interface VideoRecorderVu extends ActivityBaseView<VideoRecorderPresenter> {

    /**
     * 返回按键
     *
     * @return
     */
    int onKeyBack();

    /**
     * 视频是否录制完成
     *
     * @return
     */
    boolean isCompleteRecord();

    /**
     * 取消视频录制
     */
    void cancelAndRerecord();

    /**
     * 开始相机预览
     */
    void startPreview();

    /**
     * 是否正在发送中
     *
     * @return
     */
    boolean isSending();

    /**
     * 获取视频管理器
     *
     * @return
     */
    VideoManager getVideoManager();
}
