package com.xdja.im.uikit.action.media;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.view.ViewTreeObserver;

import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.TipsTextView;

/**
 * @Package: com.xdja.im.uikit.action.media
 * @Author: xdjaxa
 * @Creation: 2017-09-15 13:56
 * @Version V1.0
 * @Description:
 */
public class ReceiverModeManger implements SensorEventListener, Application.ActivityLifecycleCallbacks {

    private Activity mActivity;
    private float voiceMode = DEFAULT_MODE_CODE;
    /**
     * 语音播放模式初始默认值
     */
    private static final int DEFAULT_MODE_CODE = -1;
    /*
     * 传感器管理类
     */
    private SensorManager mSensorManager;
    private Sensor mSensor;

    private TipsTextView mTipsTv;

    public void init(Activity activity) {
        mActivity = activity;
        //听筒模式初始化
        mSensorManager = (SensorManager) activity.getSystemService(Context.SENSOR_SERVICE);
        mSensor = mSensorManager.getDefaultSensor(Sensor.TYPE_PROXIMITY);

        //添加Activity生命周期监听处理
        mActivity.getApplication().registerActivityLifecycleCallbacks(this);

        mTipsTv = (TipsTextView) mActivity.findViewById(R.id.tv_tips_receiver);

        initAudioMode(mActivity);
    }

    @SuppressLint("NewApi")
    public void initAudioMode(Activity activity) {
        mActivity = activity;
        mActivity.getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(
                new ViewTreeObserver.OnWindowFocusChangeListener() {
                    @Override
                    public void onWindowFocusChanged(boolean hasFocus) {
//                        if (hasFocus) {
//                            MediaManger.getInstance().initAudioManager();
//                        } else {
//                            MediaManger.getInstance().resetAudioManager();
//                        }
                    }
                });
    }

    /**
     * 注册sensor监听器
     */
    private void registerSensor() {
        mSensorManager.registerListener(this, mSensor, SensorManager.SENSOR_DELAY_NORMAL);
    }

    /**
     * 反注册sensor监听器
     */
    private void unRegisterSensor() {
        mSensorManager.unregisterListener(this);
    }

    /**
     * 注册线控耳机插拔广播
     */
    private void registerHeadset() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(Intent.ACTION_HEADSET_PLUG);
        intentFilter.addAction(AudioManager.ACTION_AUDIO_BECOMING_NOISY);
        mActivity.registerReceiver(headsetPlugReceiver, intentFilter);
    }

    /**
     * 反注册线控耳机插拔广播
     */
    private void unRegisterHeadset() {
        try {
            mActivity.unregisterReceiver(headsetPlugReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 听筒模式变化，tips提示
     */
    public void showReceiverTipsView() {

        mTipsTv.setText(R.string.im_uikit_tips_loudspeaker);
        Drawable leftDrawable = mActivity.getDrawable(R.mipmap.im_uikit_ic_tips_loudspeaker);
        if (leftDrawable != null) {
            leftDrawable.setBounds(0, 0, leftDrawable.getMinimumWidth(), leftDrawable.getMinimumHeight());
            mTipsTv.setCompoundDrawables(leftDrawable, null, null, null);
        }
        mTipsTv.showTips();
    }

    private boolean assetActivity(Activity activity) {
        return mActivity.getClass().getName().equals(activity.getClass().getName());
    }

    @Override
    public void onSensorChanged(SensorEvent event) {

        //耳机模式下，直接返回
//        if (MediaManger.getInstance().getCurrentMode() == MediaManger.MODE_HEADSET) {
//            return;
//        }
//
//        if (!AudioPlayerManager.getInstance().isPlaying()) {
//            return;
//        }
//
//        if (event.values[0] >= mSensor.getMaximumRange()) { //正常模式
//            showReceiverTipsView();
//            MediaManger.getInstance().changeToSpeakerMode();
//            MediaManger.getInstance().wakeLockBrightRelease();
//            AudioPlayerManager.getInstance().startToRePlay();
//        } else {                                            //听筒模式
//            MediaManger.getInstance().setAudioMode();
//            MediaManger.getInstance().changeToEarpieceMode();
//            MediaManger.getInstance().wakeLockBrightAcquire();
//            AudioPlayerManager.getInstance().startToRePlay();
//        }
        if (voiceMode == event.values[0] && AudioPlayerManager.getInstance().isPlaying()) {
            return;
        }
        //情景二：如果在听筒模式时，插上耳机，然后放开听筒，应该切换正常模式，耳机起作用
        if (MediaManger.getInstance().isHeadsetOn()) {

            if (event.values[0] >= mSensor.getMaximumRange()) {//正常模式
                MediaManger.getInstance().setReceiverMode(false);
                AudioPlayerManager.getInstance().startToRePlay();
                MediaManger.getInstance().onSensorChanged(false);
            }
            MediaManger.getInstance().wakeLockBrightRelease();
            return;
        }

        //情景：正在播放过程中
        if (AudioPlayerManager.getInstance().isPlaying()) {
            if (event.values[0] >= mSensor.getMaximumRange()) {//正常模式
                MediaManger.getInstance().wakeLockBrightRelease();
            } else {                                           //听筒模式
                MediaManger.getInstance().wakeLockBrightAcquire();
            }
        } else {
            MediaManger.getInstance().wakeLockBrightRelease();
        }

        voiceMode = event.values[0];
        //情景四：听筒和正常模式之间切换
        if (event.values[0] >= mSensor.getMaximumRange()) { //正常模式
            MediaManger.getInstance().setReceiverMode(false);
            MediaManger.getInstance().onSensorChanged(false);
            AudioPlayerManager.getInstance().startToRePlay();
        } else {                                            //听筒模式
            MediaManger.getInstance().setReceiverMode(true);
            MediaManger.getInstance().onSensorChanged(true);
            AudioPlayerManager.getInstance().startToRePlay();
        }


    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (assetActivity(activity)) {

            registerSensor();
            registerHeadset();
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        if (assetActivity(activity)) {

            unRegisterSensor();
            unRegisterHeadset();
        }
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        if (assetActivity(activity)) {

            MediaManger.getInstance().releaseWakeLock();
            mActivity.getApplication().unregisterActivityLifecycleCallbacks(this);
        }
    }

    private BroadcastReceiver headsetPlugReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (Intent.ACTION_HEADSET_PLUG.equals(action)) {
                int state = intent.getIntExtra("state", 0);
                if (state == 1) {
                    MediaManger.getInstance().setReceiverModeOn();
                } else if (state == 0) {
                    MediaManger.getInstance().setReceiverModeOn();
                }
            }
        }
    };
}
