package com.xdja.im.uikit.ui.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;

import java.util.List;

/**
 * @Package: com.xdja.im.uikit.ui.adapter
 * @Author: xdjaxa
 * @Creation: 2017-09-12 11:27
 * @Version V1.0
 * @Description:
 */
public class BaseListAdapter extends BaseAdapter {

    private List<ImOption> mData;

    public BaseListAdapter(List<ImOption> mData) {
        this.mData = mData;
    }

    @Override
    public int getCount() {
        return mData == null ? 0 : mData.size();
    }

    @Override
    public Object getItem(int position) {
        return mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.im_uikit_item_dialog_option, null);
            holder = new ViewHolder();
            holder.mOptionTv = (TextView) convertView.findViewById(R.id.tv_option);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        ImOption option = mData.get(position);
        if (option != null) {
            holder.mOptionTv.setText(option.getValue());
        }
        return convertView;
    }

    class ViewHolder {
        public TextView mOptionTv;
    }
}
