package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.xdja.im.base.frame.presenter.BasePagerAdapterPresenter;
import com.xdja.im.base.frame.view.PagerAdapterView;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.impl.im.IMProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.ui.presenter.FilePreviewAdapterPresenter;
import com.xdja.im.uikit.ui.view.ViewPreviewFile;
import com.xdja.im.uikit.ui.view.ViewPreviewGifImage;
import com.xdja.im.uikit.ui.view.ViewPreviewImage;
import com.xdja.im.uikit.ui.view.ViewPreviewVideo;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.ui.adapter
 * @Author: xdjaxa
 * @Creation: 2017-05-15 10:19
 * @Version V1.0
 * @Description:
 */
public class FilePreviewAdapter extends BasePagerAdapterPresenter<FilePreviewAdapterPresenter, TalkMessageBean>
        implements FilePreviewAdapterPresenter {

    private Activity mActivity;
    /**
     * 消息列表
     */
    private final List<TalkMessageBean> mDataSource;

    private IMProxyImpl mImProxyImp;

    private ImageLoader mImageLoader;

    List<Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>>> vuClasses;

    private SettingMsgIdCallback callback;

    public FilePreviewAdapter(Activity activity, List<TalkMessageBean> dataSource,
                              IMProxyImpl imProxy, ImageLoader imageLoader, SettingMsgIdCallback callback) {
        this.mActivity = activity;
        this.mDataSource = dataSource;
        this.mImProxyImp = imProxy;
        this.mImageLoader = imageLoader;
        this.callback = callback;
    }

    @Override
    protected Activity getActivity() {
        return mActivity;
    }

    @Override
    public void onPageSelected(int lastPos, int curPos) {
        if (adapterVus != null && adapterVus.containsKey(lastPos)) {
            adapterVus.get(lastPos).onPageSelected(lastPos, curPos);
        }
    }

    @Override
    public void reFreshPage(int position) {
        try {
            adapterVus.get(position).bindDataSource(position, mDataSource.get(position));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected TalkMessageBean getDataSource(int position) {
        return mDataSource == null ? null : mDataSource.get(position);
    }

    @Override
    public int getCount() {
        return mDataSource == null ? 0 : mDataSource.size();
    }

    @Override
    public int getItemViewType(int position) {
        TalkMessageBean talkMessageBean = getDataSource(position);
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("get item view type, but file is null.");
            return -1;
        }
        int type = -1;
        switch (fileInfo.getFileType()) {
            case ConstDef.FILE_TYPE_PHOTO:
                if (ConstDef.GIF_TYPE.equalsIgnoreCase(talkMessageBean.getFileInfo().getSuffix())) {
                    //fix bug 21394 by jyg 20171017
                    type = Constant.ITEM_TYPE_GIF_IMAGE;
                } else {
                    type = Constant.ITEM_TYPE_IMAGE;
                }
                //type = Constant.ITEM_TYPE_IMAGE;
                break;
            case ConstDef.FILE_TYPE_VIDEO:
                type = Constant.ITEM_TYPE_VIDEO;
                break;
            case ConstDef.FILE_TYPE_NORMAL:
                type = Constant.ITEM_TYPE_FILE;
                break;
        }
        return type;
    }

    @NonNull
    @Override
    protected Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>> vuClass = null;
        switch (itemViewType) {
            case Constant.ITEM_TYPE_IMAGE:
                vuClass = getVuClasses().get(0);
                break;
            case Constant.ITEM_TYPE_VIDEO:
                vuClass = getVuClasses().get(1);
                break;
            case Constant.ITEM_TYPE_FILE:
                vuClass = getVuClasses().get(2);
                break;
            case Constant.ITEM_TYPE_GIF_IMAGE:
                vuClass = getVuClasses().get(3);
                break;
        }
        return vuClass;
    }

    @Override
    protected List<Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>>> getVuClasses() {
        if (vuClasses == null) {
            vuClasses = new ArrayList<>();
            vuClasses.add(ViewPreviewImage.class);
            vuClasses.add(ViewPreviewVideo.class);
            vuClasses.add(ViewPreviewFile.class);
            vuClasses.add(ViewPreviewGifImage.class);
        }
        return vuClasses;
    }

    @Override
    protected FilePreviewAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    public void loadImage(ImageView imageView, String filePath, ImageView.ScaleType scaleType, int width, int height) {
        mImageLoader.loadImage(getActivity(), imageView, filePath, scaleType, width, height);
//        Glide.with(getActivity())
//                .load(filePath)
//                .override(width,height)
//                .into(imageView);
    }

    @Override
    public void download(FileInfo fileInfo) {

        //网络不可用提示
        /*if (!NetworkUtil.isNetworkConnected(getActivity())) {
            CommonTool.showToast(R.string.im_uikit_net_not_available);
        }*/

        List<FileInfo> fileInfoList = new ArrayList<>();
        fileInfoList.add(fileInfo);

        mImProxyImp.downloadFile(fileInfoList, new Subscriber<Integer>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(Integer integer) {
            }
        });
    }

    @Override
    public void saveFile(File srsFile, String savePath, final String fileName) {
        mImProxyImp.saveFile(srsFile, savePath, fileName, new Subscriber<String>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {
                LogUtil.e("ERROR: Save file failed.");
                CommonTool.showToast(R.string.im_uikit_hint_save_failed);
            }

            @Override
            public void onNext(String savePath) {
                CommonTool.showToast(String.format(
                        getActivity().getString(R.string.im_uikit_hint_save_image),
                        savePath));
                Intent intent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
                Uri uri = Uri.fromFile(new File(savePath));
                intent.setData(uri);
                getActivity().sendBroadcast(intent);
            }
        });
    }

    @Override
    public void deleteMsg(TalkMessageBean bean) {
        if (callback == null) {
            return;
        }
        int index = 0;
        int length = mDataSource.size();
        for (int i = 0; i < length; i++) {
            TalkMessageBean tempBean = mDataSource.get(i);
            if (bean.getId() == tempBean.getId()) {
                index = i;
                if (length > 1) {
                    if (i == 0) {
                        callback.setCurMsgId(mDataSource.get(1).getId());
                    } else {
                        callback.setCurMsgId(mDataSource.get(i - 1).getId());
                    }

                }
                break;
            }
        }

        if (mDataSource != null && mDataSource.contains(bean)) {
            mDataSource.remove(bean);
        }

        callback.updateUI();
        callback.selectPage(index, bean);

        if (mDataSource.size() == 0) {
            if (callback != null) {
                callback.showEmptyView();
            }
        }
    }

    public void onPause(int position) {
        if (adapterVus != null && adapterVus.containsKey(position)) {
            adapterVus.get(position).onViewPause();
        }
    }

    public interface SettingMsgIdCallback {

        void setCurMsgId(long msgId);

        void updateUI();

        void showEmptyView();

        void selectPage(int index, TalkMessageBean bean);
    }
}
