package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;

import com.xdja.im.base.frame.presenter.BaseItemAdapterPresenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.ui.ListItemUtils;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.ViewCustomSessionItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSessionItem;
import com.xdja.im.uikit.ui.view.ViewGroupItem;
import com.xdja.im.uikit.ui.view.ViewSingleItem;
import com.xdja.im.uikit.ui.view.ViewSystemSessionItem;

import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.presenter.adapter
 * @Author: xdjaxa
 * @Date: 2017-04-10 18:00
 * @Version V1.0
 * @Comment: 会话列表适配器
 */
public class SessionListAdapter extends BaseItemAdapterPresenter<SessionListAdapterPresenter, TalkSessionBean>
        implements SessionListAdapterPresenter {

    private Activity mActivity;

    private final List<TalkSessionBean> mDataSource;

    private List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> vuClasses;

    private SessionListPresenter sessionListPresenter;

    public SessionListAdapter(Activity activity, List<TalkSessionBean> mDataSource, SessionListPresenter sessionListPresenter) {
        this.mActivity = activity;
        this.mDataSource = mDataSource;
        this.sessionListPresenter = sessionListPresenter;
    }

    @Override
    protected Activity getActivity() {
        return mActivity;
    }

    @Override
    public int getViewTypeCount() {
        return ListItemUtils.getInstance().getSessionListItemTypeSize();
    }

    @Override
    public int getItemViewType(int position) {
        if (mDataSource != null) {
            int talkType = mDataSource.get(position).getTalkType();
            switch (talkType) {
                case ConstDef.CHAT_TYPE_P2P:
                    return ConstDef.SESSION_TYPE_P2P;
                case ConstDef.CHAT_TYPE_P2G:
                    return ConstDef.SESSION_TYPE_P2G;
                case ConstDef.CHAT_TYPE_CUSTOM:
                    return ConstDef.SESSION_TYPE_CUSTOM;
                case ConstDef.CHAT_TYPE_SYSTEM_INFO:
                    if (mDataSource.get(position).getTalkerAccount().equals(ConstDef.FILE_TRANSFER_ASS_ACCOUNT)) {
                        return ConstDef.SESSION_TYPE_SYSTEM_FILE;
                    } else
                        return ConstDef.SESSION_TYPE_SYSTEM_INFO;
                default:
                    return ConstDef.SESSION_TYPE_DEFAULT;
            }
        }
        return ConstDef.SESSION_TYPE_DEFAULT;
    }

    @Override
    protected Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getVuClassByViewType(int itemViewType) {
        return ListItemUtils.getInstance().getSessionListItemByTypeKey(itemViewType);
    }

    @Override
    protected SessionListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected TalkSessionBean getDataSource(int position) {
        return mDataSource == null ? null : mDataSource.get(position);
    }

    @Override
    public int getCount() {
        return mDataSource == null ? 0 : mDataSource.size();
    }

    @Override
    public Object getItem(int position) {
        return mDataSource.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public MeetInfo ifShowMeetTip() {
        return sessionListPresenter.ifShowMeetTip();
    }
}
