package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.GifImageView;

import static com.xdja.im.lib.filemanage.util.HistoryFileUtils.isFileExist;


/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:42
 * @Version V1.0
 * @Description:
 */
public class ViewSendImageItem extends BaseSendItem {

    private static final int MAX_PLAY_GIF = 3 * 1024 * 1024;

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * gif
     */
    private GifImageView mGifImageView;
    /**
     * 闪信标识
     */
    private ImageView mBombFlagImg;

    /**
     * 图片接收进度
     */
    private ProgressBar progressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mGifImageView = (GifImageView) findViewById(R.id.img_send_gif_image);
        mBombFlagImg = (ImageView) findViewById(R.id.img_bomb_flag);
        progressBar = (ProgressBar) findViewById(R.id.pbar_loading);

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (FileUtils.isFileExists(dataSource.getFileInfo().getFilePath())) {
                    getPresenter().previewImage(dataSource);
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        ImageFileInfo fileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }

        //加载图片
        loadImage(fileInfo, dataSource);

        //闪信标识
        if (dataSource.isBomb()) {
            mBombFlagImg.setVisibility(View.VISIBLE);
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        /**
         * 1.本地文件存在，并且大小相等加载
         * 2.本地文件存在，文件大小不相等，等待回调加载
         * 3.本地文件不存在，但是出于下载状态，没有下载完成的情况下，转圈等待
         * 4.本地文件不存在，已经下载完成或者发送完完成，本地图片被删除，则显示默认图片
         * 5.本地文件不存在，正在发送的过程中，图片被删除，显示默认图片
         */
        //本地图片存在
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            if (imageFileInfo.getFileSize() == FileUtils.getFileLength(imageFileInfo.getFilePath())) {
                //mChatImage.loadImage(filePath);
                imageSynchronousAccept(false);
                loadImageUrl(imageFileInfo, dataSource);
                LogUtil.d("createScaledBitmap ViewSendImageItem state " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId());
            }
            LogUtil.d("createScaledBitmap ViewSendImageItem size " + " msgId : " + dataSource.getId());
        } else {
            if (showDefaultImageMessageState(imageFileInfo,dataSource)) {
                LogUtil.w("file is not exit.");
                imageSynchronousAccept(false);
                mChatImage.setError(R.mipmap.im_uikit_pic_default);
                LogUtil.d("createScaledBitmap ViewSendImageItem state1 " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId() );
            } else {
                imageSynchronousAccept(true);
                getPresenter().downLoadFile(dataSource, imageFileInfo);
                LogUtil.d("createScaledBitmap ViewSendImageItem state2 " + imageFileInfo.getFileState() + " msgId : " + dataSource.getId());
            }

        }
    }

    private boolean showDefaultImageMessageState(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        return imageFileInfo.getFileState() == ConstDef.DONE
                || imageFileInfo.getFileState() == ConstDef.FAIL
                || dataSource.getMessageState() == ConstDef.STATE_SEND_FAILED
                || dataSource.getMessageState() == ConstDef.STATE_SENDING;
    }



    /**
     * 加载URL指定图片
     *
     * @param imageFileInfo
     */
    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        //fix bug 21243 by jyg 20171017
        if (imageFileInfo != null && ConstDef.GIF_TYPE.equalsIgnoreCase(suffix)
                && !TextUtils.isEmpty(imageFileInfo.getFilePath())) {
            final String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            //fix bug 21243 by jyg 20171017
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.VISIBLE);
            /*if (isFileExist(urlGif)) {
                mGifImageView.loadImageFrame(urlGif);
                if (fileSize <= MAX_PLAY_GIF) {
                    Glide.with(getActivity())
                            .load(urlGif)
//                            .error(R.mipmap.im_uikit_pic_default)
 //                           .placeholder(R.mipmap.im_uikit_pic_default)
                            .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                            .listener(new RequestListener<String, GlideDrawable>() {
                                @Override
                                public boolean onException(Exception e, String s, Target<GlideDrawable> target, boolean b) {
                                    mGifImageView.loadImageFrame(urlGif);
                                    return true;
                                }

                                @Override
                                public boolean onResourceReady(GlideDrawable glideDrawable, String s, Target<GlideDrawable> target, boolean b, boolean b1) {
                                    return false;
                                }
                            })
                            .dontAnimate()
                            .into(mGifImageView);

                }
            }*/
            mGifImageView.loadImageFrame(urlGif);

            if (dataSource.isGifPlayed()) {
                mGifImageView.stopAnimation();
            } else {
                if (isFileExist(urlGif) &&fileSize < MAX_PLAY_GIF ) {
                    mGifImageView.loadImage(urlGif);
                }
            }
        } else {
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.GONE);
            mChatImage.loadImage(imageFileInfo.getFilePath(),ConstDef.SEND_IMAGE);
        }
    }

    private void imageSynchronousAccept(boolean accept) {
        if (accept) {
            progressBar.setVisibility(View.VISIBLE);
            mChatImage.setVisibility(View.GONE);
            mGifImageView.setVisibility(View.GONE);
        } else {
            progressBar.setVisibility(View.GONE);
            mChatImage.setVisibility(View.VISIBLE);
            mGifImageView.setVisibility(View.VISIBLE);
        }
    }

}
