package com.xdja.im.uikit.utils;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.provider.MediaStore;

import com.xdja.im.lib.filemanage.util.ActomaController;

public class PromptPictureUtils extends ContentObserver {
    public Uri imageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    private static PromptPictureUtils promptPictureUtils;
    public boolean isImageChange = false;

    /**
     * Creates a content observer.
     *
     * @param handler The handler to run {@link #onChange} on, or null if none.
     */
    public PromptPictureUtils(Handler handler) {
        super(handler);
    }

    public static PromptPictureUtils getInstance() {
        if (promptPictureUtils == null) {
            synchronized (PromptPictureUtils.class) {
                if (promptPictureUtils == null) {
                    promptPictureUtils = new PromptPictureUtils(new Handler());
                }
            }
        }
        return promptPictureUtils;
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange);
        if (MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString().equalsIgnoreCase(uri.toString())) {
            isImageChange = true;
        }
    }

    public void registerContentObserver(Context context) {
        if (context != null && context.getContentResolver() != null)
            context.getContentResolver().registerContentObserver(imageUri, false, this);
    }


    public void unRegisterContentObserver(Context context) {
        if (context != null && context.getContentResolver() != null) {
            try {
                context.getContentResolver().unregisterContentObserver(this);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 获取相册中最新的一张图片
     */
    public String getLatestPhotoPath() {
        long imageDate = 0;
        String path = null;
        if (isImageChange) {
            //查询内容
            String[] projection = {MediaStore.Images.Media._ID,
                    MediaStore.Images.Media.DISPLAY_NAME,
                    MediaStore.Images.Media.DATA,
                    MediaStore.Images.Media.SIZE,
                    MediaStore.Images.Media.WIDTH,
                    MediaStore.Images.Media.HEIGHT,
                    MediaStore.Images.Media.MIME_TYPE,
                    MediaStore.Images.Media.DATE_ADDED};
            String sortOrder = MediaStore.Images.Media.DATE_MODIFIED + " desc";
            Cursor cursor = ActomaController.getAppConfigContext().getContentResolver().
                    query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, sortOrder);

            if (cursor != null) {
                if (cursor.moveToNext()) {
                    path = cursor.getString(cursor.getColumnIndex("_data"));
                    String dateAdd = cursor.getString(cursor.getColumnIndex("date_added"));
                    imageDate = Long.valueOf(dateAdd);
                }
            }
            cursor.close();
        }
        isImageChange = false;
        long curTime = System.currentTimeMillis() / 1000;
        if (curTime - imageDate <= 30) {
            return path;
        } else {
            return null;
        }

    }


}
