package com.xdja.im.uikit.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowInsets;
import android.widget.LinearLayout;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-04-12 11:18
 * @Version V1.0
 * @Description:
 */
public class KeyboardLayout extends LinearLayout {

    private Activity mActivity;

    private int[] mInsets = new int[4];

    public KeyboardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public KeyboardLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public KeyboardLayout(Context context) {
        super(context);
    }

    public void setActivity(Activity activity) {
        mActivity = activity;
    }

    /**
     * 获取软键盘高度
     *
     * @return
     */
    public float getSupportSoftInputHeight() {
        if (mActivity == null) {
            return -1;
        }

        Rect r = new Rect();
        View decorView = mActivity.getWindow().getDecorView();
        decorView.getWindowVisibleDisplayFrame(r);

        float screenHeight = decorView.getRootView().getHeight();

        float softInputHeight = screenHeight - r.bottom;
        if (Build.VERSION.SDK_INT >= 20) {
            int bottomHeight = getBottomButtonWidth();
            softInputHeight = softInputHeight - bottomHeight;
        }

        return softInputHeight;
    }

    /**
     * 获取底部导航栏的高度
     *
     * @return
     */
    private int getBottomButtonWidth() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        mActivity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int unRealHeight = displayMetrics.heightPixels;

        mActivity.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
        int realHeight = displayMetrics.heightPixels;

        if (unRealHeight < realHeight) {
            return realHeight - unRealHeight;
        } else {
            return 0;
        }
    }

    /**
     * 判断软键盘是否弹出
     *
     * @return
     */
    public boolean isSoftInputShown() {
        float height = getSupportSoftInputHeight();
        return height > 0;
    }

    @Override
    public WindowInsets computeSystemWindowInsets(WindowInsets in, Rect outLocalInsets) {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            // Intentionally do not modify the bottom inset. For some reason,
            // if the bottom inset is modified, window resizing stops working.
            mInsets[0] = outLocalInsets.left;
            mInsets[1] = outLocalInsets.top;
            mInsets[2] = outLocalInsets.right;

            outLocalInsets.left = 0;
            outLocalInsets.top = 0;
            outLocalInsets.right = 0;
        }
        return super.computeSystemWindowInsets(in, outLocalInsets);
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
            mInsets[0] = insets.getSystemWindowInsetLeft();
            mInsets[1] = insets.getSystemWindowInsetTop();
            mInsets[2] = insets.getSystemWindowInsetRight();
            return super.onApplyWindowInsets(insets.replaceSystemWindowInsets(0, 0, 0,
                    insets.getSystemWindowInsetBottom()));
        } else {
            return insets;
        }
    }

}
