package com.xdja.im.uikit.view;


import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;

import java.lang.ref.WeakReference;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-09-15 15:41
 * @Version V1.0
 * @Description:
 */
public class TipsTextView extends AppCompatTextView {

    public static final int MSG_SHOW = 0;

    public static final int MSG_GONE = 1;

    private  Handler handler = new mHandler(this);

    public TipsTextView(Context context) {
        super(context);
    }

    public TipsTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public TipsTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void showTips() {
        setVisibility(VISIBLE);
        if (handler != null) {
            handler.sendEmptyMessageDelayed(MSG_GONE, 1000);
        }
    }

    public void hideTips() {
        if (getVisibility() == VISIBLE) {
            setVisibility(GONE);
            if (handler != null) {
                handler.removeMessages(MSG_SHOW);
                handler.removeMessages(MSG_GONE);
            }
        }
    }

    public static class mHandler extends Handler{
        private WeakReference<TipsTextView> mContext;
        public mHandler (TipsTextView context)  {
            mContext = new WeakReference<TipsTextView>(context);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            TipsTextView context = mContext.get();
            if (context != null) {
                switch (msg.what) {
                    case MSG_GONE:
                        context.hideTips();
                        break;
                }
            }

        }
    };
}
