package com.xdja.im.common.network.api;

import com.xdja.im.common.network.body.ReportBody;
import com.xdja.im.uikit.entity.NoDisturbConfig;
import com.xdja.im.uikit.entity.NoDisturbSetter;
import com.xdja.im.uikit.entity.SessionTopSetter;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import rx.Observable;

/**
 * @Package: com.xdja.im.common.network
 * @Author: xdjaxa
 * @Creation: 2017-05-24 14:21
 * @Version V1.0
 * @Description:用户设置相关REST API
 */
public interface UserSettingApi {

    @PUT("pntoken")
    Observable<Object> loginReport(@Body ReportBody body);

    /**
     * @param account
     * @return 获取置顶设置
     */
    @GET("account/top/{account}")
    Observable<List<String>> getSettingTopSettings(@Path("account") String account);
    /**
     * @param setter
     * @return 保存云端置顶设置
     */
    @PUT("account/top/update")
    Call<ResponseBody> saveSessionTopSettings(@Body SessionTopSetter setter);
    /**
     * @param setter
     * @return 删除云端置顶设置
     */
    @PUT("account/top/delete")
    Call<ResponseBody> deleteSessionTopSettings(@Body SessionTopSetter setter);

    @PUT("account/nodisturb/update")
    Call<ResponseBody> saveNoDisturbSettings(@Body NoDisturbSetter setter);

    @PUT("account/nodisturb/delete")
    Call<ResponseBody> deleteNoDisturbSettings(@Body NoDisturbSetter setter);

    @GET("account/nodisturb/{account}")
    Observable<List<NoDisturbConfig>> getNoDisturbSettings(@Path("account") String account);
}
