package com.xdja.im.core.model.message;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

/**
 * Created by xdjaxa on 2017/6/1.
 */
public class AtInfo implements Parcelable {
    private List<String> accounts;
    private String content;


    public AtInfo(List<String> accounts, String content) {
        this.accounts = accounts;
        this.content = content;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<String> accounts) {
        this.accounts = accounts;
    }

    protected AtInfo(Parcel in) {
        accounts = in.createStringArrayList();
        content = in.readString();
    }

    public static final Creator<AtInfo> CREATOR = new Creator<AtInfo>() {
        @Override
        public AtInfo createFromParcel(Parcel in) {
            return new AtInfo(in);
        }

        @Override
        public AtInfo[] newArray(int size) {
            return new AtInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeStringList(accounts);
        parcel.writeString(content);
    }
}
