package com.xdja.im.lib.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.audio.widget.AudioRecorderButton;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.PastEditText;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-04-12 11:21
 * @Version V1.0
 * @Description:消息输入操作栏
 */
public class ChatInputView extends LinearLayout {

    /**
     * 输入框最大输入长度
     */
    private final int MAX_INPUT_SIZE = 2048;

    /**
     * 更多面板
     */
    private ImageView mMoreImg;
    /**
     * 选中闪信/表情
     */
    private ImageView mShanImg;
    /**
     * 语音文字输入切换
     */
    private CheckBox mInputSwitchChx;
    /**
     * 文字输入框
     */
    private PastEditText mInputEdt;
    /**
     * 录音按钮
     */
    private AudioRecorderButton mRecorderBtn;
    /**
     * 发送按钮
     */
    private Button mSendBtn;

    private boolean isInitFirst;

    private String groupId;

    private String account;

    private int mChatType = ConstDef.CHAT_TYPE_P2P;

    private Toast mToast;

    private boolean isDraft = false;

    public void setChatType (int chatType) {
        this.mChatType = chatType;
    }

    public void setIsDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public void setGroupId (String groupId) {
        this.groupId = groupId;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public ChatInputView(Context context) {
        super(context);
        initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public ChatInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView() {
        View.inflate(getContext(), R.layout.im_uikit_layout_chat_operate, this);
        isInitFirst = true;
        mMoreImg = (ImageView) findViewById(R.id.img_more_action);
        mShanImg = (ImageView) findViewById(R.id.img_shan_action);
        mInputSwitchChx = (CheckBox) findViewById(R.id.chx_input_switch);
        mInputEdt = (PastEditText) findViewById(R.id.edt_input_text);
        mRecorderBtn = (AudioRecorderButton) findViewById(R.id.btn_input_voice);
        mSendBtn = (Button) findViewById(R.id.btn_send);
    }

    boolean isTouchEditText;

    public void registerActionViewCallBack(final IChatActionCallback callback) {
        //文本输入监听事件
        mInputEdt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                isDraft = false;
                s.length();
            }

            @Override
            public void afterTextChanged(Editable s) {
                int length = s.toString().length();
                if (length > MAX_INPUT_SIZE) {
//                    s = s.delete(MAX_INPUT_SIZE, length);
                    mInputEdt.setText(s.subSequence(0,MAX_INPUT_SIZE));
                }

                // 文本长度为0时最右边显示为语音切换
                if (s.length() == 0) {
                    mSendBtn.setVisibility(GONE);
                    mMoreImg.setVisibility(View.VISIBLE);
                } else if (isInitFirst && !mInputEdt.hasFocus()) {
                    mSendBtn.setVisibility(GONE);
                    mMoreImg.setVisibility(View.VISIBLE);
                    isInitFirst = false;
                } else {
                    mSendBtn.setVisibility(View.VISIBLE);
                    mMoreImg.setVisibility(View.GONE);
                }
                /*if (s.length() == 0) {
                    mSendBtn.setEnabled(false);
                } else {
                    mSendBtn.setEnabled(true);
                }*/
            }
        });

        mInputEdt.setOnKeyListener(new View.OnKeyListener(){
            @Override
            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                if (keyEvent.getAction() == KeyEvent.ACTION_DOWN && i == KeyEvent.KEYCODE_DEL && keyEvent.getRepeatCount() == 0) {
                    deleteAtStr();
                }
                return false;
            }
        });

        //文本编辑框点击监听事件
        mInputEdt.setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                mInputEdt.setFocusable(true);
                mInputEdt.setFocusableInTouchMode(true);
                mInputEdt.requestFocus();
                if (!TextUtils.isEmpty(getInputText())) {
                   // isDraft = true;
                    mSendBtn.setVisibility(View.VISIBLE);
                    mMoreImg.setVisibility(View.GONE);
                }
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    isTouchEditText = true;
                    mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
                    callback.onInputEareTouchCallBack();
                }
                return false;
            }
        });

        //文本语音输入切换监听
        mInputSwitchChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                switchToInputEdt(!isChecked);
                callback.onInputCheckChanged(!isChecked);
            }
        });

        //闪信/文本切换
        mShanImg.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                setMoreState(false);
                switchToInputEdt(true);
                mInputSwitchChx.setChecked(false);
                callback.onShanCheckChanged();
            }
        });

        //更多选择切换监听
        mMoreImg.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                setShanState(false);
                switchToInputEdt(true);
                mInputSwitchChx.setChecked(false);
                callback.onMoreCheckChanged();
            }
        });

        //发送按钮点击事件监听
        mSendBtn.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                callback.onSendTextCallBack();
            }
        });

        //录音完成回调事件监听
        mRecorderBtn.setAudioFinishRecorderListener(new AudioRecorderButton.AudioFinishRecorderListener() {
            @Override
            public void onFinish(float seconds, String filePath) {
                callback.onRecorderFinish((int) seconds, filePath);
            }
        });

        mInputEdt.setFilters(new InputFilter[]{new CusInputFilter()});
    }

    /**
     * 切换至文本输入
     *
     * @param isSwitch
     */
    public void switchToInputEdt(boolean isSwitch) {
        if (isSwitch) {
            mInputEdt.setVisibility(VISIBLE);
            mRecorderBtn.setVisibility(GONE);
            mInputEdt.requestFocus();
            if (getInputEdt().length() == 0) {
                mSendBtn.setVisibility(GONE);
                mMoreImg.setVisibility(View.VISIBLE);
            } else {
                mSendBtn.setVisibility(View.VISIBLE);
                mMoreImg.setVisibility(View.GONE);
            }
        } else {
            mInputEdt.setVisibility(GONE);
            mRecorderBtn.setVisibility(VISIBLE);
            mSendBtn.setVisibility(View.GONE);
            mMoreImg.setVisibility(View.VISIBLE);
        }
    }

    /**
     * 获取输入的文字信息
     */
    public String getInputText() {
        return mInputEdt.getText().toString();
    }

    /**
     * 设置输入显示信息
     *
     * @param text 文本信息
     */
    public void setInputText(CharSequence text) {
        mInputEdt.setText(EmotionUtils.formatNormalSpanContent(text, getContext()));
        mInputEdt.setFocusable(true);
        mInputEdt.setFocusableInTouchMode(true);
        mInputEdt.requestFocus();
        int index = 0;
        if (!TextUtils.isEmpty(text) && !TextUtils.isEmpty(mInputEdt.getText()))
            index = mInputEdt.getText().length();
        mInputEdt.setSelection(index);
    }

    /**
     * 获取输入框，设置给表情View
     */
    public EditText getInputEdt() {
        return mInputEdt;
    }

    public void setMoreState(boolean isChecked) {
        if (!TextUtils.isEmpty(getInputText()) && mInputEdt.isShown()) {
            mMoreImg.setVisibility(View.GONE);
            mSendBtn.setVisibility(View.VISIBLE);
            mInputEdt.requestFocus();
        } else {
            mSendBtn.setVisibility(View.GONE);
            mMoreImg.setVisibility(View.VISIBLE);

            if (isChecked) {
                mMoreImg.setImageResource(R.mipmap.im_uikit_actioin_chat_panel_press);
            } else {
                mMoreImg.setImageResource(R.mipmap.im_uikit_action_chat_panel_normal);
            }
        }
    }

    public void setShanState(boolean isChecked) {
        if (isChecked) {
            mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_keyinput_normal);
        } else {
            mShanImg.setImageResource(R.mipmap.im_uikit_action_chat_emotion_normal);
        }
    }

    //添加过滤器
    private class CusInputFilter implements InputFilter{
        @Override
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if(!isDraft && mChatType == ConstDef.CHAT_TYPE_P2G && canAtFriend(source)) {
                //@跳转
                IMUiKitProxyImpl.getInstance().go2AtGroupMembersList(groupId,account);
            }
            return null;
        }
    }

    //判断@条件
    private boolean canAtFriend(CharSequence charSequence) {
        String str = mInputEdt.getText().toString();
        String string = str.substring(0, mInputEdt.getSelectionEnd());
        return (mInputEdt.getText().length() == 0 || !englishOrDigital(string)) && charSequence.toString().equalsIgnoreCase(ConstDef.at);
    }

    //判断字符串
    private static boolean englishOrDigital(String str) {
        if (str == null) return false;

        if (str.length() >= 1 && englishOrDigital(str.charAt(str.length() - 1))) {
            return true;
        }
        return false;
    }

    //判断字符
    private static boolean englishOrDigital(char c) {
        return (c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') ||  (c >= 'A' && c <= 'Z');
    }


    private void deleteAtStr() {
        // 获取光标的位置
        int cursonIndex = mInputEdt.getSelectionStart();
        int leftIndex;
        if (cursonIndex > 0) {
            // 获取输入框整体字符串
            String content = mInputEdt.getText().toString();
            if (!TextUtils.isEmpty(content)) {
                content = content.substring(0, cursonIndex);
                int rightIndex = content.lastIndexOf(" ");
                if (rightIndex != -1 && rightIndex == content.length() - 1) {
                    leftIndex = content.lastIndexOf("@");
                    if (leftIndex != -1) {
                        String temp = content.substring(leftIndex,
                                rightIndex + 1);
                        Pattern pattern = Pattern.compile("(@.+\\s)");
                        Matcher matcher = pattern.matcher(temp);
                        if (matcher.matches()) {
                            mInputEdt.getEditableText().delete(leftIndex + 1,
                                    cursonIndex);
                            return;
                        }
                    }
                }
                leftIndex = cursonIndex;
                mInputEdt.getEditableText().delete(leftIndex, cursonIndex);
                return;

            }
        }
    }

}
