package com.xdja.im.lib.album.ui.presenter;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.lib.album.bean.ImageItem;

import java.util.List;

/**
 * @Package: com.xdja.im.lib.album.ui.command
 * @Author: xdjaxa
 * @Creation: 2017-04-25 17:48
 * @Version V1.0
 * @Description:
 */
public interface ImagePreviewPresenter extends Presenter {

    /**
     * 获取当前图片的个数
     *
     * @return
     */
    int getImageSize();

    /**
     * 获取指定位置的图片信息
     *
     * @param position 位置
     * @return
     */
    ImageItem getImageItem(int position);

    /**
     * 更新集合数据
     * @param position
     * @param imageItem
     */
    void updateItem(int position, ImageItem imageItem);

    /**
     * 发送图片
     */
    void sendImages(boolean isPromptPicture,List<ImageItem> dataList);

    /**
     * 获取是否是提示图片进来的页面
     */
     boolean isPromptPicture();
}
