package com.xdja.im.lib.emoji.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.xdja.im.lib.emoji.EmotionConfig;
import com.xdja.im.lib.emoji.ui.adapter.GridViewAdapter;
import com.xdja.im.lib.emoji.ui.adapter.ViewPageAdapter;
import com.xdja.im.uikit.R;

import java.util.ArrayList;
import java.util.List;


public class EmotionGridView extends LinearLayout {
    /**
     * ViewPager
     */
    private ViewPager mViewPager;
    /**
     * 底部导航布局
     */
    private LinearLayout mDotLayout;
    /**
     * 点集合
     */
    private ImageView[] mDots;
    /**
     * ViewPager当前页
     */
    private int mCurrentIndex;
    /**
     * ViewPager页数
     */
    private int mPagerSize;
    /**
     * 监听器
     */
    private OnFaceGridViewItemClick onFaceGridViewItemClick;

    public EmotionGridView(Context context) {
        this(context, null);
    }

    public EmotionGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initViewPage();
        initFootDots();
    }

    @SuppressWarnings("deprecation")
    private void initViewPage() {
        setOrientation(VERTICAL);
        /* viewpage背景颜色 */
        int backColor = 0x00cccfd0;
        setBackgroundColor(backColor);// 灰色
        mViewPager = new ViewPager(getContext());
        mViewPager.setOffscreenPageLimit(4);
        mViewPager.setOverScrollMode(View.OVER_SCROLL_NEVER);
        LayoutParams pagerParams = new LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.MATCH_PARENT);
        pagerParams.weight = 1;
        pagerParams.bottomMargin = 18;
        mViewPager.setLayoutParams(pagerParams);
        addView(mViewPager);

        mDotLayout = new LinearLayout(getContext());
        LinearLayout.LayoutParams dotParams = new LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.WRAP_CONTENT);
        dotParams.bottomMargin = 5;
        mDotLayout.setLayoutParams(dotParams);
        mDotLayout.setGravity(Gravity.CENTER_HORIZONTAL);
        mDotLayout.setOrientation(HORIZONTAL);
        addView(mDotLayout);
    }

    private void initFootDots() {
        /* 默认一页21个item */
        double pageItemCount = 20d;
        mPagerSize = (int) Math.ceil(EmotionConfig.EMOJ_SIZE / pageItemCount);

        if (0 < mPagerSize) {
            if (mPagerSize == 1) {
                mDotLayout.setVisibility(View.GONE);
            } else {
                mDotLayout.setVisibility(View.VISIBLE);
                for (int i = 0; i < mPagerSize; i++) {
                    ImageView image = new ImageView(getContext());
                    image.setTag(i);
                    LayoutParams params = new LayoutParams(
                            20, 20);
                    params.setMargins(5, 5, 5, (int) getResources().getDimension(R.dimen.im_uikit_face_layout_imageview_margin));
                    // 两种调用图片方式
                    image.setBackgroundResource(R.drawable.im_uikit_dots_set);
                    image.setEnabled(false);
                    mDotLayout.addView(image, params);
                }
            }
        }
        if (1 != mPagerSize) {
            mDots = new ImageView[mPagerSize];
            for (int i = 0; i < mPagerSize; i++) {
                mDots[i] = (ImageView) mDotLayout.getChildAt(i);
                mDots[i].setEnabled(true);
                mDots[i].setTag(i);
            }
            mCurrentIndex = 0;
            mDots[mCurrentIndex].setEnabled(false);
            mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                }

                @Override
                public void onPageSelected(int position) {
                    setCurDot(position);
                }

                @Override
                public void onPageScrollStateChanged(int state) {

                }
            });
        }
    }

    private void setCurDot(int position) {
        if (position < 0 || position > mPagerSize - 1
                || mCurrentIndex == position) {
            return;
        }
        mDots[position].setEnabled(false);
        mDots[mCurrentIndex].setEnabled(true);
        mCurrentIndex = position;
    }

    public void setAdapter() {
        if (onFaceGridViewItemClick == null) {
            return;
        }
        /* 保存每个页面的GridView视图 , 把这个list暴露出去,用于setOnClickListener */
        List<GridView> views = new ArrayList<>();
        for (int i = 0; i < mPagerSize; i++) {
            views.add(getViewPagerItem(i));
        }
        mViewPager.setAdapter(new ViewPageAdapter(views));

    }

    /**
     * 生成gridView数据
     */
    @SuppressLint("DefaultLocale")
    @SuppressWarnings("getGridViewData")
    private String[] getGridViewData(int index) {
        index++;
        int startPos = (index - 1) * EmotionConfig.FACE_PAGE_SIZE;
        int endPos = index * EmotionConfig.FACE_PAGE_SIZE;
        int length;

        if (endPos > EmotionConfig.EMOJ_SIZE) {
            endPos = EmotionConfig.EMOJ_SIZE - 1;
        }
        length = endPos - startPos + 1;
        String[] tmps = new String[length];

        int num = 0;
        // 表情页面某一页内的表情图片名称集合
        for (int i = startPos; i < endPos; i++) {
            tmps[num] = "sticker/emotion/emoji_" + String.format("%03d", i) + ".png";
            num++;
        }
        /* assets 返回按钮图片 */
        String backBtnName = "back_normal";
        tmps[length - 1] = backBtnName;
        return tmps;
    }

    @SuppressWarnings("deprecation")
    private GridView getViewPagerItem(int index) {
        final GridView gridView = new GridView(getContext());
        gridView.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.WRAP_CONTENT));
        gridView.setNumColumns(7);
        // gridView.setStretchMode(GridView.STRETCH_SPACING);
        gridView.setSelector(R.drawable.im_uikit_transparent);
        gridView.setVerticalScrollBarEnabled(false);
        gridView.setHorizontalScrollBarEnabled(false);
        gridView.setBackgroundColor(Color.TRANSPARENT);
        gridView.setAdapter(new GridViewAdapter(getContext(),
                getGridViewData(index)));
        gridView.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view,
                                    int position, long id) {
                // 点击最后一个，清除动作
                if (position == gridView.getChildCount() - 1) {
                    onFaceGridViewItemClick.onClear();
                } else {// 添加表情
                    onFaceGridViewItemClick.onItemClick(mCurrentIndex
                            * EmotionConfig.FACE_PAGE_SIZE + position);
                }
            }
        });
        return gridView;
    }

    public void setOnFaceGridViewItemClick(
            OnFaceGridViewItemClick onFaceGridViewItemClick) {
        this.onFaceGridViewItemClick = onFaceGridViewItemClick;
    }

    public interface OnFaceGridViewItemClick {
        void onItemClick(int facesPos);

        void onClear();
    }
}
