package com.xdja.im.lib.filemanage.adapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ExpandableListView;
import android.widget.ProgressBar;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.util.FileInfoCollection;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.filemanage.view.ViewHistoryFileTitle;
import com.xdja.im.lib.filemanage.view.ViewLastFileContent;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;


/**
 * 项目名称：ActomaV2
 * 类描述：
 * 创建人：xdjaxa
 * 创建时间：2016/12/14 21:01
 * 修改人：xdjaxa
 * 修改时间：2016/12/14 21:01
 * 修改备注：
 */
public class LastFileListAdapterPresenter extends BaseFileItemAdapterPresenter<IHistoryFileListAdapterCommand,TalkMessageBean>
        implements IHistoryFileListAdapterCommand{

    private ExpandableListView listView;


    BusProvider busProvider;

//    @Inject
//    Lazy<ContactService> contactService;

    private Activity mActivity;

    private final UserCache userCache;

    public LastFileListAdapterPresenter(Context context, BusProvider busProvider, UserCache userCache,
                                        Map<HistoryFileCategory, List<TalkMessageBean>> datas){
        mContext = context;
        this.busProvider = busProvider;
        this.userCache = userCache;
        this.busProvider.register(this);
        mDatas = datas;
    }

    public void setDataSource(Map<HistoryFileCategory, List<TalkMessageBean>> datas){
        mDatas = datas;
    }

    @Override
    public void sendReadReceipt(TalkMessageBean talkMessageBean) {
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> getVuClasses() {
        if(mVuClass == null){
            mVuClass = new ArrayList<>();
            mVuClass.add(ViewLastFileContent.class);
        }

        return mVuClass;
    }

    @Override
    public List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, String>>> getGroupVuClasses() {
        if(mGroupVuClass == null) {
            mGroupVuClass = new ArrayList<>();
            mGroupVuClass.add(ViewHistoryFileTitle.class);
        }
        return mGroupVuClass;
    }

    @Override
    public IHistoryFileListAdapterCommand getCommand() {
        return this;
    }

    @Override
    public void notifyDataSetChanged() {
        mTitles = new ArrayList<>(mDatas.keySet());
        Collections.sort(mTitles);
        super.notifyDataSetChanged();
    }

    @Override
    public void updateItem(int position,long msgId) {
        if(position < 0){
            return ;
        }
        //fix bug 7809 by zya 20170104
        HistoryFileCategory cate = mTitles.get(position);

        List<TalkMessageBean> beans = mDatas.get(cate);
        TalkMessageBean tBean = new TalkMessageBean();
        tBean.setId(msgId);

        int childPosition = beans.indexOf(tBean);
        if(childPosition > -1){
            int childCount = listView.getChildCount();
            //匹配到子View
            if(position == 0 && listView.isGroupExpanded(0)){
                int firstVisiblePos = listView.getFirstVisiblePosition();
                if(childPosition + 1 < firstVisiblePos){
                    return ;
                }

                int aPos = childPosition - firstVisiblePos  + 1;
                Log.d("lvchao","zhu->childPos:" + childPosition + ",firstPos:" + firstVisiblePos + ",aPos:" + aPos);

                View childView = listView.getChildAt(aPos);
                if(childView != null) {
                    ProgressBar pb = (ProgressBar) childView.findViewById(R.id.pb_file_download);
                    pb.setProgress(beans.get(childPosition).getFileInfo().getTranslatePercent());
                }
            }
        }
        //end by zya
    }
    @Override
    public void toRefreshSelectHint() {
    }

    @Override
    public void toRefreshSelectHint(FileItem localFileInfo) {
        IMProxyEvent.FileSelectedEvent event = new IMProxyEvent.FileSelectedEvent(localFileInfo);
        busProvider.post(event);
    }

    @Override
    public void onClickItem(View v, int groupPosition, TalkMessageBean bean) {
        CheckBox checkBox = (CheckBox)v.getTag(R.id.history_file_select);
        if(checkBox == null){
            return;
        }
        if(FileInfoCollection.getInstance().getSelectedFileCount() >= 9 && !checkBox.isChecked()){
            new XToast(ImUiKit.getInstance().getContext()).display(String.format(ImUiKit.getInstance().getContext().getString(R.string.im_uikit_select_file_hint), 9));
            return;
        }
        checkBox.setChecked(!checkBox.isChecked());
    }

    @Override
    public void longClickOnItem(int groupPosition,TalkMessageBean bean) {
        if(mItemLongClickListener != null){
            mItemLongClickListener.itemLongClick(groupPosition,bean);
        }
    }

//    @Override
//    public AccountBean getAccountBean(String account) {
//        return IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2P);
//    }
//
//    @Override
//    public AccountBean getGroupMemberInfo(String groupId, String account) {
//        return IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2G);
//    }

    public void setListView(ExpandableListView listView){
        this.listView = listView;
    }

    public void setActivity(Activity activity){
        mActivity = activity;
    }

    @Override
    public Activity getActivity() {
        return mActivity;
    }

    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand,String>>> mGroupVuClass = null;

    private List<Class<? extends AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean>>> mVuClass = null;

    private ItemLongClickListener mItemLongClickListener;

    public interface ItemLongClickListener{
        void itemLongClick(int groupPosition, TalkMessageBean bean);
    }

    public void setItemLongClickListener(ItemLongClickListener listener){
        mItemLongClickListener = listener;
    }

    public void onDestroy(){
        if (null != busProvider) {
            //注销事件总线回调
            busProvider.unregister(this);
        }
    }

    @Override
    public void clickToDownloadOfOpen(TalkMessageBean bean) {

    }
}

