package com.xdja.im.lib.filemanage.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.NetworkHelper;


/**
 * Created by xdjaxa on 2017/4/7.
 */
public class NetworkUtils {

    public static int WIFI = 1;
    public static int MOBILE_NETWORK = 2;
    public static int UNUSABLE = -1;

    public static int obtainCurrentNetworkState(Context context) {

        // 获取手机所有连接管理对象（包括对wi-fi,net等连接的管理）
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (connectivityManager != null) {
            NetworkInfo mobNetInfo = connectivityManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
            NetworkInfo wifiNetInfo = connectivityManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

            //如果是wifi连接成功，就表示有网络可用
            if (wifiNetInfo.isConnected()) {
                return WIFI;
            } else if(mobNetInfo.isConnected()){
                //如果是仅移动网络可用，就要判断是否开启仅wifi可用
                return MOBILE_NETWORK;
            }
        }

        return UNUSABLE;
    }

    public static boolean checkNetworkState(Context context){
        int state = NetworkHelper.getHelper().getNetState();
        switch (state){
            case NetworkHelper.NET_DISABLED:
                new XToast(context).display(R.string.im_uikit_network_disabled);
                return false;
            case  NetworkHelper.NO_SERVER:
                new XToast(context).display(R.string.im_uikit_network_no_server);
                return false;
            case NetworkHelper.NET_OK:
                return true;
            default:
                return false;
        }
    }
}
