package com.xdja.im.lib.historyfile.vu;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewHistoryPhotoItem extends ViewHistoryBaseItem {

    private ImageView imageView;

    private CheckBox isSelected;

    private CircleProgressBar circleProgressBar;

    private TextView imageShade;

    private int style = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_file_image_fragment_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        style = UniversalUtil.getThemeStyle(getContext());
        if (view != null) {
            imageView = (ImageView) view.findViewById(R.id.image_file_image);
            isSelected = (CheckBox) view.findViewById(R.id.chx_img_file_select);
            circleProgressBar = (CircleProgressBar) view.findViewById(R.id.image_down_cpb);
            imageShade = (TextView) view.findViewById(R.id.image_file_shade);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull GridItemBean dataSource) {
        super.bindDataSource(position, dataSource);
        final TalkMessageBean dataTalk = (TalkMessageBean) dataSource.getValue();
        final FileInfo fileInfo = dataTalk.getFileInfo();

        circleProgressBar.setMax(100);
        if(fileInfo.getFileState() == ConstDef.LOADING){
            circleProgressBar.setVisibility(View.VISIBLE);
        } else {
            circleProgressBar.setVisibility(View.GONE);
        }

        if (!HistoryFileUtils.isFileExist(dataTalk) && !dataTalk.isMine() &&
                DateUtils.isOverdue(dataTalk.getShowTime())){
            imageShade.setVisibility(View.VISIBLE);
        } else {
            imageShade.setVisibility(View.GONE);
        }

        if(HistoryFileUtils.isSendReadReceipt(dataTalk)){
            getCommand().sendReadReceipt(dataTalk);
        }

        isSelected.setVisibility(dataTalk.hasFileOperate() ? View.VISIBLE : View.GONE);
        isSelected.setClickable(false);

        isSelected.setButtonDrawable(dataTalk.isChecked() ? (style ==
                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                R.drawable.im_uikit_icon_selected_off);

        isSelected.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                dataTalk.setChecked(isChecked);
                isSelected.setButtonDrawable(isChecked ? (style ==
                        BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_icon_selected_on : R.drawable.im_uikit_icon_selected_on_light) :
                        R.drawable.im_uikit_icon_selected_off);
                if (isChecked) {
                    HistoryModeUtils.getInstance().putFileToSelectedCache(dataTalk.getId(), dataTalk);
                } else {
                    HistoryModeUtils.getInstance().removeToSelectedCache(dataTalk.getId());
                }
                getCommand().toRefreshSelectHint();
            }
        });
        isSelected.setChecked(dataTalk.isChecked());

        Glide.with(getActivity())
                .load(fileInfo.getFilePath())
                .asBitmap()
                .placeholder(R.drawable.im_uikit_ic_jpg)
//                .dontAnimate()
//                .error(R.drawable.im_uikit_ic_jpg)
                .into(imageView);
    }
}
