package com.xdja.im.lib.share.presenter;


import android.app.Activity;
import android.content.Intent;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.model.WebPageInfo;

import java.util.List;

/**
 * Created by wenqi on 2018/3/1.
 */

public interface ShareSessionListPresenter extends Presenter {

    /**
     * 获取Activity对象
     *
     * @return
     */
    Activity getActivity();

    /**
     * 搜索
     */
    void onSearchChanged(String searchKey);

    /**
     * 创建新会话
     */
    void onCreateSessionClick();

    /**
     * 选择群组
     */
    void onSelectGroup();

    /**
     * 列表项被点击
     *
     */
    void onListItemClick(TalkSessionBean item);

    /**
     * 对话框确认发送
     * @param list
     * @param intentBean
     * @param dialogContent
     */
    void onDialogRequestSend(List<ShareBean> list, IntentBean intentBean, String dialogContent);

    /**
     * 对话框取消发送
     */
    void onDialogCancleSend();

    /**
     * 对话框分享完成确认
     */
    void onTipsDialogTrueClick();
    /**
     * 对话框分享完成取消
     */
    void onTipsDialogClick();

    /**
     * 发送文本消息
     *
     * @param message 文本消息内容
     * @return {@code true} 消息可发送，并且发送的动作操作成功 <br />
     * {@code false} 消息不可发送，或者发送的动作操作失败
     */
    boolean sendTextMessage(String message,String sendTo,int type);

    /**
     * 发送文件消息
     *
     * @param fileList 文件列表
     * @return {@code true} 消息可发送，并且发送的动作操作成功 <br />
     * {@code false} 消息不可发送，或者发送的动作操作失败
     */
    void sendFileMessage(List<FileInfo> fileList,String sendTo,int type);

    void onDialogRequestForwardSend(List<ShareBean> list, Intent intent, String liuYan);

    /**
     * 发送Web消息
     *
     * @param sendTo
     * @param type
     */
    boolean sendWebMessage(WebPageInfo fileList, String sendTo, int type);
}
