package com.xdja.im.lib.video.palyer;

/**
 * @Package: com.xdja.im.lib.video.palyer
 * @Author: xdjaxa
 * @Creation: 2017-05-16 9:38
 * @Version V1.0
 * @Description:视频播放器
 */
public interface VideoPlayer {

    /**
     * 开始播放
     *
     * @param filePath 视频文件路径
     */
    void play(String filePath, boolean isRepeat);

    /**
     * 暂停播放
     */
    void pause();

    /**
     * 恢复播放
     */
    void resume();

    /**
     * 停止播放
     */
    void stop();

    /**
     * 销毁
     */
    void destroy();

    /**
     * 重置
     */
    void reset();

    /**
     * 是否正在播放中
     *
     * @return
     */
    boolean isPlaying();

    /**
     * 获取播放状态
     *
     * @return
     */
    VideoPlayState getPlayState();

    /**
     * 获取当前播放进度
     *
     * @return
     */
    int getCurrentPosition();
}
