package com.xdja.im.uikit.ui;

import android.util.SparseArray;
import android.util.SparseIntArray;

import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.view.CustomBaseChatItem;
import com.xdja.im.uikit.ui.view.ViewCustomRecItem;
import com.xdja.im.uikit.ui.view.ViewCustomSendItem;
import com.xdja.im.uikit.ui.view.ViewCustomSessionItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSendItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSessionItem;
import com.xdja.im.uikit.ui.view.ViewGroupItem;
import com.xdja.im.uikit.ui.view.ViewNotifyItem;
import com.xdja.im.uikit.ui.view.ViewRecvFileItem;
import com.xdja.im.uikit.ui.view.ViewRecvImageItem;
import com.xdja.im.uikit.ui.view.ViewRecvLocationItem;
import com.xdja.im.uikit.ui.view.ViewRecvTextItem;
import com.xdja.im.uikit.ui.view.ViewRecvVideoItem;
import com.xdja.im.uikit.ui.view.ViewRecvVoiceItem;
import com.xdja.im.uikit.ui.view.ViewRecvWebItem;
import com.xdja.im.uikit.ui.view.ViewSendFileItem;
import com.xdja.im.uikit.ui.view.ViewSendImageItem;
import com.xdja.im.uikit.ui.view.ViewSendLocationItem;
import com.xdja.im.uikit.ui.view.ViewSendTextItem;
import com.xdja.im.uikit.ui.view.ViewSendVideoItem;
import com.xdja.im.uikit.ui.view.ViewSendVoiceItem;
import com.xdja.im.uikit.ui.view.ViewSendWebItem;
import com.xdja.im.uikit.ui.view.ViewSingleItem;
import com.xdja.im.uikit.ui.view.ViewSystemFileSessionItem;
import com.xdja.im.uikit.ui.view.ViewSystemSessionItem;

/**
 * Created by wenqi on 2018/6/9.
 * 用于加载聊天页面或者聊天列表对应的ITEM
 */

public class ListItemUtils {


    private static ListItemUtils itemUtils;
    private SparseArray<Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>>> chatListItemSparseArray = new SparseArray<>();
    private SparseArray<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> sessionListItemSparseArray = new SparseArray<>();
    private SparseIntArray customTypeArray = new SparseIntArray();

    private ListItemUtils() {
        initSessionListItems();
        initChatListItems();
    }

    public static ListItemUtils getInstance() {
        if (itemUtils == null) {
            synchronized (ListItemUtils.class) {
                if (itemUtils == null) {
                    itemUtils = new ListItemUtils();
                }
            }
        }
        return itemUtils;
    }

    private void initSessionListItems() {
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_P2P, ViewSingleItem.class);
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_P2G, ViewGroupItem.class);
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_CUSTOM, ViewCustomSessionItem.class);
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_DEFAULT, ViewDefaultSessionItem.class);
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_SYSTEM_INFO, ViewSystemSessionItem.class);
        sessionListItemSparseArray.put(ConstDef.SESSION_TYPE_SYSTEM_FILE, ViewSystemFileSessionItem.class);
    }

    public Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getSessionListItemByTypeKey(int type) {
        return sessionListItemSparseArray.get(type);
    }


    public int getSessionListItemTypeSize() {
        return sessionListItemSparseArray.size();
    }


    private void initChatListItems() {

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_TEXT, ViewSendTextItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_TEXT, ViewRecvTextItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_VOICE, ViewSendVoiceItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_VOICE, ViewRecvVoiceItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_IMAGE, ViewSendImageItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_IMAGE, ViewRecvImageItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_VIDEO, ViewSendVideoItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_VIDEO, ViewRecvVideoItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_FILE, ViewSendFileItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_FILE, ViewRecvFileItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_WEB, ViewSendWebItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_WEB, ViewRecvWebItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_LOCATION, ViewSendLocationItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_RECEIVE_LOCATION, ViewRecvLocationItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_NOTIFY, ViewNotifyItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_SEND_CUSTOM, ViewCustomSendItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_DEFAULT, ViewDefaultSendItem.class);

        chatListItemSparseArray.put(Constant.ITEM_TYPE_REC_CUSTOM, ViewCustomRecItem.class);

    }

    public Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>> getChatListItemByTypeKey(int type) {
        return chatListItemSparseArray.get(type);
    }


    public int getChatListItemTypeSize() {
        return chatListItemSparseArray.size();
    }

    public synchronized void addChatListItemAndPaser(int customType, Class<? extends CustomBaseChatItem> customItem) {
        customTypeArray.put(customType, chatListItemSparseArray.size());
        chatListItemSparseArray.put(chatListItemSparseArray.size(), customItem);
    }

    public int getRealCustomType(int customType) {
        return customTypeArray.get(customType);
    }

}
