package com.xdja.im.uikit.ui.view;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.constans.Constant;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:38
 * @Version V1.0
 * @Description:聊天栏目消息接收基类
 */
public class BaseReceiveItem extends BaseChatItem {

    /**
     * 内容布局
     */
    protected RelativeLayout mContentLayout;
    /**
     * 闪信销毁动画控件
     */
    private ImageView mBombAnimImg;

    /**
     * 发送者名称
     */
//    private TextView mUserName;

    private LinearLayout newMessageRemind;

    @Override
    protected void injectView() {
        super.injectView();
        mContentLayout = (RelativeLayout) findViewById(R.id.layout_message_container);
        mBombAnimImg = (ImageView) findViewById(R.id.img_bomb_anim);
        mUserName = (TextView) findViewById(R.id.txt_chat_senderName);
//        senderNameTextView = (TextView) findViewById(R.id.txt_chat_senderName);
        newMessageRemind = (LinearLayout) findViewById(R.id.no_read_remaind);

        mContentLayout.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return showPopDialog();
            }
        });
        mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                dismissPopDialog();
                switch (option.getOptionType()) {
                    case Constant.ITEM_CHAT_DELETE:  //删除消息
                        getPresenter().deleteItem(itemPosition);
                        break;
                    case Constant.ITEM_CHAT_COPY:    //复制消息
                        getPresenter().copyMessage(itemPosition);
                        break;
                    case Constant.ITEM_CHAT_FORWARD: //消息转发
                        getPresenter().forwardMessage(itemPosition);
                        break;
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource.isGroupMsg()) {
            mUserName.setVisibility(View.VISIBLE);
        } else {
            mUserName.setVisibility(View.GONE);
        }
        if (dataSource.isRemind()) {
            newMessageRemind.setVisibility(View.VISIBLE);
        } else {
            newMessageRemind.setVisibility(View.GONE);
        }
//        getPresenter().getAccount(dataSource.getFrom() ,ConstDef.CHAT_TYPE_P2P,
//                new Subscriber<AccountBean>() {
//                    @Override
//                    public void onCompleted() {
//
//                    }
//
//                    @Override
//                    public void onError(Throwable e) {
//                        LogUtil.d("BaseReceiveItem" , "获取联系人信息出错");
//                    }
//
//                    @Override
//                    public void onNext(AccountBean accountBean) {
//                        mUserName.setText(accountBean.getDisplayName());
//                    }
//                });

    }

    /**
     * 设置消息显示控件背景
     *
     * @param resId 资源文件id
     */
    protected void setContentLayoutBackground(@DrawableRes int resId) {
        mContentLayout.setBackgroundResource(resId);
    }

    /**
     * 开始闪信动画
     */
    protected void startBombAnim() {
        if (mBombAnimImg != null) {
            AnimationDrawable boomAnim = (AnimationDrawable) mBombAnimImg.getBackground();
            boomAnim.stop();
            boomAnim.start();
        }
    }

    protected void setMessageDestroy(boolean isDestroy) {
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_PHOTO ||
                dataSource.getMessageType() == ConstDef.MSG_TYPE_VIDEO) {
            return;
        }
        if (mContentLayout != null) {
            if (isDestroy) {
                mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_shan_selector);
            } else {
                mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_selector);
            }
        }
    }


    protected void setDestroyView(TextView destroyView, boolean isDestroy, String destroyStr) {
        if (destroyView != null) {
            if (isDestroy) {
                destroyView.setVisibility(View.VISIBLE);
                destroyView.setTextColor(getLimitTextColor());
                destroyView.setText(destroyStr);
            } else {
                destroyView.setVisibility(View.GONE);
            }
        }
    }

    /**
     * 显示选择框
     */
    protected boolean showPopDialog() {
        List<ImOption> data = new ArrayList<>();
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_TEXT &&
                dataSource.getMessageState() != ConstDef.STATE_DESTROY) {
            data.add(mImOptions.get(0));
            data.add(mImOptions.get(1));
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        } else {
            data.add(mImOptions.get(0));
        }
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_AT_TEXT) {
            data.add(mImOptions.get(1));
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        }
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_VIDEO) {
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        }
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_PHOTO) {
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        }
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_FILE) {
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        }
        if (dataSource.getMessageType() == ConstDef.MSG_TYPE_WEB) {
            if (CommonTool.getHasForward() != 1)
                data.add(mImOptions.get(4));
        }
        mPopDialog.addData(data);
        mPopDialog.show(curPosition);
        return true;
    }

    /**
     * 隐藏选择框
     */
    private void dismissPopDialog() {
        if (mPopDialog != null) {
            mPopDialog.dismiss();
        }
    }
}

