package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:38
 * @Version V1.0
 * @Description:聊天栏目基类
 */
public class CustomBaseChatItem extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
        implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {

    /**
     * 时间差
     */
    public static final long TIME_DIFFERENCE = 5 * 60 * 1000;
    /**
     * 时间线
     */
    private TextView mTimeLineTv;
    /**
     * 未读新消息提醒
     */
    private LinearLayout newMessageRemind;

    @Override
    protected void injectView() {
        super.injectView();
        mTimeLineTv = (TextView) findViewById(R.id.tv_timeLine);
        newMessageRemind = (LinearLayout) findViewById(R.id.no_read_remaind);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        //时间线计算
        if (position == 0) {
            setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = getPresenter().getTalkMessage(curPosition);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > TIME_DIFFERENCE) {
                mTimeLineTv.setVisibility(View.VISIBLE);
                mTimeLineTv.setText(TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                mTimeLineTv.setVisibility(View.GONE);
            }
        }
        if (dataSource.isRemind()) {
            newMessageRemind.setVisibility(View.VISIBLE);
        } else {
            newMessageRemind.setVisibility(View.GONE);
        }

        //发送阅读回执
        if (dataSource.getMessageState() < ConstDef.STATE_READED) {
            getPresenter().sendReadReceipt(dataSource);
        }
    }

    private void setTimeLineVisible(long time) {
        mTimeLineTv.setVisibility(View.VISIBLE);
        mTimeLineTv.setText(TimeUtil.convertChatTime(time));
    }
}
