package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;
import com.xdja.im.uikit.ui.presenter.FileDownloadPresenter;
import com.xdja.im.uikit.ui.view.vu.FileDownloadVu;
import com.xdja.im.uikit.utils.file.FileUtils;

/**
 * Created by guorong on 2016/11/30.
 */
public class ViewFileDownload extends ImActivitySuperView<FileDownloadPresenter>
        implements FileDownloadVu {

    //显示文件图标
    private ImageView fileLogoIv;
    //文件名称
    private TextView fileNameTv;
    //文件下载进度条
    private ProgressBar progressBar;
    //文件下载大小
    private TextView downloadSizeTv;
    //下载控制按钮
    private Button ctrlBtn;
    //安通+无法打开文件提示
    private TextView tipsTv;

    private NormalFileInfo fileInfo;

    private String fileSizeText;

    private TalkMessageBean talkMessageBean = null;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_download;
    }

    @Override
    protected int getToolbarType() {
        return ImActivitySuperView.ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_download_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        fileLogoIv = (ImageView) view.findViewById(R.id.file_logo);
        fileNameTv = (TextView) view.findViewById(R.id.file_name);
        progressBar = (ProgressBar) view.findViewById(R.id.download_rate);
        downloadSizeTv = (TextView) view.findViewById(R.id.download_size);
        ctrlBtn = (Button) view.findViewById(R.id.ctrl_btn);
        tipsTv = (TextView) view.findViewById(R.id.tips);
    }

    private void updateProgressBar() {
        progressBar.setProgress((int) (fileInfo.getTranslateSize() * 100 / fileInfo.getFileSize()));
    }

    @SuppressLint("SetTextI18n")
    private void setDownloadRateText() {
        String downloadSizeText = FileSizeUtils.formatFileSize(fileInfo.getTranslateSize());
        String text = downloadSizeText + "/" + fileSizeText;
        downloadSizeTv.setText(getStringRes(R.string.im_uikit_loading) + "(" + text + ")");
    }

    /**
     * 更新下载进度
     */
    @Override
    public void updateDownloadRate() {
        updateProgressBar();
        setDownloadRateText();
    }

    /**
     * 文件下载完成
     */
    @Override
    public void downloadFileFinish() {
        progressBar.setVisibility(View.INVISIBLE);
        downloadSizeTv.setVisibility(View.INVISIBLE);
        ctrlBtn.setText(R.string.im_uikit_open_with_other_app);
        tipsTv.setVisibility(View.VISIBLE);
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void setData() {
        fileInfo = getPresenter().getCurFileInfo();
        fileSizeText = FileSizeUtils.formatFileSize(fileInfo.getFileSize());
        fileLogoIv.setImageResource(getFileIcon(fileInfo));
        fileNameTv.setText(fileInfo.getFileName());
        tipsTv.setText(getResources().getString(R.string.im_uikit_cannot_open));
        if (fileInfo.getFileState() == ConstDef.DONE) {
            //文件下载已完成
            progressBar.setVisibility(View.INVISIBLE);
            downloadSizeTv.setVisibility(View.INVISIBLE);
            tipsTv.setVisibility(View.VISIBLE);
            ctrlBtn.setText(R.string.im_uikit_open_with_other_app);
        } else {
            progressBar.setVisibility(View.VISIBLE);
            progressBar.setProgress((int) (fileInfo.getTranslateSize() * 100.0f / fileInfo.getFileSize()));
            downloadSizeTv.setVisibility(View.VISIBLE);
            tipsTv.setVisibility(View.GONE);
            //文件下载未完成
            if (fileInfo.getFileState() == ConstDef.PAUSE) {
                ctrlBtn.setText(R.string.im_uikit_resume_download);
            } else {
                ctrlBtn.setText(R.string.im_uikit_pause_download);
            }
        }
        downloadSizeTv.setText(getStringRes(R.string.im_uikit_loading) +
                "(" + FileSizeUtils.formatFileSize(fileInfo.getTranslateSize())
                + "/" + fileSizeText + ")");
        ctrlBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (talkMessageBean != null && talkMessageBean.getMessageState() == ConstDef.STATE_RECALL_SUCCESS) {
                    new XToast(getActivity()).display(getActivity().getString(R.string.im_uikit_file_recall_not_click));
                    return;
                }
                if (fileInfo.getFileState() == ConstDef.DONE) {
                    progressBar.setVisibility(View.INVISIBLE);
                    downloadSizeTv.setVisibility(View.INVISIBLE);
                    getPresenter().openFile();
                } else {
                    progressBar.setVisibility(View.VISIBLE);
                    downloadSizeTv.setVisibility(View.VISIBLE);
                    if (fileInfo.getFileState() == ConstDef.LOADING) {
                        getPresenter().pauseDownloadFile();
                        ctrlBtn.setText(R.string.im_uikit_resume_download);
                    } else if (fileInfo.getFileState() == ConstDef.PAUSE) {
                        getPresenter().downLoadFile(false);

                    }
                }
            }
        });
    }

    @Override
    public void changeViewSate(int state) {
        if (state != 0) {
            if (fileInfo != null && fileInfo.getFileState() == ConstDef.LOADING) {
                getPresenter().pauseDownloadFile();
                fileInfo.setFileState(ConstDef.PAUSE);
                ctrlBtn.setText(R.string.im_uikit_resume_download);
            }
        }
    }

    @Override
    public void setCtrlBtnText(int res) {
        if (ctrlBtn != null) {
            ctrlBtn.setText(res);
        }
    }

    private int getFileIcon(NormalFileInfo fileInfo) {
        return FileUtils.getIconWithSuffix(fileInfo.getFilePath());
    }

    @Override
    public void setReCallBtnText(TalkMessageBean reCallMsg) {
        talkMessageBean = reCallMsg;
        if (ctrlBtn != null) {
            ctrlBtn.setText(R.string.im_uikit_resume_download);
        }
    }
}
