package com.xdja.im.uikit.ui.view;

import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;
import com.xdja.im.uikit.view.PhotoView;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @Package: com.xdja.im.uikit.ui.view
 * @Author: xdjaxa
 * @Creation: 2017-05-15 11:35
 * @Version V1.0
 * @Description:图片预览界面
 */
public class  ViewPreviewImage extends BaseFilePreview {

    /**
     * 图片加载控件
     */
    private PhotoView mPhotoView;
    /**
     * 查看原图按钮
     */
    private Button mOriginalBtn;
    /**
     * 图片加载控件
     */
    private ProgressBar mLoadingPbar;
    /**
     * 屏幕信息
     */
    private ScreenInfo mScreenInfo;
    /**
     * 选项框
     */
    private BaseListDialog mDialog;

    private static final int MAX_LENGTH = 1500;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_preview_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mPhotoView = (PhotoView) findViewById(R.id.view_photo);
        mOriginalBtn = (Button) findViewById(R.id.btn_original);
        mLoadingPbar = (ProgressBar) findViewById(R.id.pbar_loading);

        mScreenInfo = ScreenUtil.getScreenInfo(getActivity());

        mDialog = new BaseListDialog(getContext()) {
            @Override
            public List<ImOption> getOptions() {
                return buildImOption();
            }
        };

        mOriginalBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (DateUtils.isOverdue(dataSource.getShowTime())) {
                    new XToast(getActivity()).display(R.string.im_uikit_history_select_all_overdue);
                    return;
                }
                mOriginalBtn.setVisibility(View.GONE);
                mLoadingPbar.setVisibility(View.VISIBLE);
                ImageFileInfo imageFileInfo = (ImageFileInfo) dataSource.getFileInfo();
                FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
                if (rawFileInfo == null) {
                    LogUtil.w("ERROR: raw file info is null.");
                }
                imageFileInfo.setType(ConstDef.IS_RAW);
                imageFileInfo.setFileState(ConstDef.LOADING);
                dataSource.setFileInfo(imageFileInfo);
                getPresenter().download(imageFileInfo);
            }
        });
        mPhotoView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                //长按事件
                mDialog.show();
                return false;
            }
        });
        mDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener() {
            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                switch (option.getOptionType()) {
                    case 0:
                        savePhoto();
                        break;
                    case 1:
                        deletePhoto();
                        break;
                }
            }
        });
        mPhotoView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().finish();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo imageFileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (imageFileInfo == null) {
            loadError();
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();

        /**
         * 有原图：
         * 1.显示有原图按钮
         * 2.原图存在，并且下载了，显示原图 ，隐藏按钮
         * 3.高清存在，并且下载了 显示高清 显示按钮
         * 4.加载缩略，显示按钮
         *
         * 没有原图：
         * 1.有高清，并且高清下载了 显示高清
         * 2.高清没有下载，直接加载缩略图
         */
        if (imageFileInfo.isOriginal()) {
            if (loadOriginalImage(imageFileInfo)) {
                return;
            }
            if (isFileDownload(imageFileInfo.getFilePath()) && imageFileInfo.getFileSize() == FileUtils.getFileLength(imageFileInfo.getFilePath())) {
                loadImage(imageFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
            } else if (imageFileInfo.getFileState() == ConstDef.FAIL) {
                loadError();
            } else {
                if (!isFileDownload(imageFileInfo.getFilePath())
                        && imageFileInfo.getFileState() == ConstDef.DONE) {
                    loadError();
                } else {
                    if (imageFileInfo.getFileState() == ConstDef.PAUSE) {
                        loadError();
                    } else {
                        mLoadingPbar.setVisibility(View.VISIBLE);
                        //Load thumb image.
                        loadThumbImage(imageFileInfo.getFilePath());
                        imageFileInfo.setType(ConstDef.IS_RAW);
                        getPresenter().download(imageFileInfo);
                    }

                }

            }
        } else {
            if (hdFileInfo != null) {
                if (isFileDownload(hdFileInfo.getFilePath()) && hdFileInfo.getFileSize() == FileUtils.getFileLength(hdFileInfo.getFilePath())) {
                    loadImage(hdFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
                } else if (imageFileInfo.getFileState() == ConstDef.FAIL) {
                    loadError();
                } else {
                    if (!isFileDownload(imageFileInfo.getFilePath())
                            && imageFileInfo.getFileState() == ConstDef.DONE) {
                        loadError();
                    } else {
                        if (imageFileInfo.getFileState() == ConstDef.PAUSE) {
                            loadError();
                        } else {
                            mLoadingPbar.setVisibility(View.VISIBLE);
                            //Load thumb image.
                            loadThumbImage(imageFileInfo.getFilePath());
                            imageFileInfo.setType(ConstDef.IS_HD);
                            getPresenter().download(imageFileInfo);
                        }
                    }
                }
            }
        }

        /*    if (hdFileInfo != null) {
                if (isFileDownload(hdFileInfo.getFilePath()) && hdFileInfo.getFileState() == ConstDef.DONE) {
                    loadImage(hdFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
                } else if (imageFileInfo.getFileState() == ConstDef.FAIL) {
                    loadError();
                } else *//*if (imageFileInfo.getFileState() == ConstDef.INACTIVE)*//* {
                    mLoadingPbar.setVisibility(View.VISIBLE);
                    //Load thumb image.
                    loadThumbImage(imageFileInfo.getFilePath());
                    imageFileInfo.setType(ConstDef.IS_HD);
                    getPresenter().download(imageFileInfo);
                }
            }

        } else {
            if (hdFileInfo != null) {
                if (isFileDownload(hdFileInfo.getFilePath())) {
                   loadImage(hdFileInfo.getFilePath(), imageFileInfo.isOriginal(), imageFileInfo.getFilePath());
                } else if (hdFileInfo.getFileState() == ConstDef.FAIL) {
                    loadError();
                } else if (hdFileInfo.getFileState() == ConstDef.INACTIVE) {
                    mLoadingPbar.setVisibility(View.VISIBLE);
                    //Load thumb image.
                    loadThumbImage(imageFileInfo.getFilePath());
                    imageFileInfo.setType(ConstDef.IS_HD);
                    getPresenter().download(imageFileInfo);
                }
            }
        }*/
    }

    private List<ImOption> buildImOption() {
        List<ImOption> data = new ArrayList<>();
        data.add(new ImOption(0, getStringRes(R.string.im_uikit_preview_option_save)));
        data.add(new ImOption(1, getStringRes(R.string.im_uikit_preview_option_delete)));
        return data;
    }

    /**
     * 设置是否显示原图按钮
     *
     * @param imageFileInfo
     */
    private boolean loadOriginalImage(ImageFileInfo imageFileInfo) {
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo == null) {
            LogUtil.e("ERROR: Has original image, but raw entity is null.");
            return false;
        }

        if (isFileDownload(rawFileInfo.getFilePath()) && rawFileInfo.getFileSize() == FileUtils.getFileLength(rawFileInfo.getFilePath())) {
            loadImage(rawFileInfo.getFilePath(), true, imageFileInfo.getFilePath());
            return true;
        } else if (!isFileDownload(rawFileInfo.getFilePath()) && rawFileInfo.getFileState() == ConstDef.DONE){
            loadError();
            return true;
        } else {
            mOriginalBtn.setVisibility(View.VISIBLE);
            mOriginalBtn.setText(String.format(getStringRes(R.string.im_uikit_download_original),
                    FileSizeUtils.formatFileSize(rawFileInfo.getFileSize())));
        }
        return false;
    }

    /**
     * 加载失败显示图片
     */
    private void loadError() {
        mPhotoView.disenable();
        ViewGroup.LayoutParams params = mPhotoView.getLayoutParams();
        params.width = ViewGroup.LayoutParams.WRAP_CONTENT;
        params.width = ViewGroup.LayoutParams.WRAP_CONTENT;

        mPhotoView.setScaleType(ImageView.ScaleType.CENTER);
        mPhotoView.setImageResource(R.mipmap.im_uikit_pic_default);
        mLoadingPbar.setVisibility(View.GONE);
        mOriginalBtn.setVisibility(View.GONE);
    }

    /**
     * 加载缩略图
     *
     * @param filePath
     */
    private void loadThumbImage(String filePath) {
        mPhotoView.disenable();
        mPhotoView.setAdjustViewBounds(false);
//        BitmapFactory.Options options = new BitmapFactory.Options();
//        options.inJustDecodeBounds = true;
//        BitmapFactory.decodeFile(filePath, options);
        ViewGroup.LayoutParams params = mPhotoView.getLayoutParams();
        params.width = mScreenInfo.getWidth() / 4;
        params.width = mScreenInfo.getHeight() / 4;
        getPresenter().loadImage(mPhotoView, filePath, ImageView.ScaleType.FIT_CENTER,
                mScreenInfo.getWidth() / 4, mScreenInfo.getWidth() / 4);
    }

    /**
     * 加载本地图片
     *
     * @param filePath
     */
    private void loadImage(String filePath, boolean isOriginal, final String thFilePath) {
        if (isFileDownload(filePath)) {
            mLoadingPbar.setVisibility(View.GONE);
            mPhotoView.enable();
            mPhotoView.setAdjustViewBounds(true);
            ViewGroup.LayoutParams params = mPhotoView.getLayoutParams();
            params.width = ViewGroup.LayoutParams.MATCH_PARENT;
            params.width = ViewGroup.LayoutParams.MATCH_PARENT;

            //获取图片大小
            final BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(filePath, options);
            if (options.outWidth > MAX_LENGTH || options.outHeight > MAX_LENGTH) {
                mPhotoView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
            } else {
                mPhotoView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
            }

            Drawable thDrawable = getDrawableRes(R.drawable.im_uikit_pic_default);

            int reqWidth;
            if (options.outWidth > 0 && options.outHeight > 0) {
                try {
                    if (options.outHeight / options.outWidth >= 3) {
                        reqWidth = mScreenInfo.getHeight() * options.outWidth / options.outHeight;
                        mPhotoView.setMaxScale(((float) mScreenInfo.getWidth() - 100) / (float) reqWidth);
                        if (isOriginal) {
                            Glide.with(getActivity())
                                    .load(filePath)
                                    .override(options.outWidth, options.outHeight)
                                    .error(thDrawable)
                                    .dontAnimate()
                                    .into(mPhotoView);
                        } else {
                            Glide.with(getActivity())
                                    .load(filePath)
                                    .error(thDrawable)
                                    .dontAnimate()
                                    .into(mPhotoView);
                        }

                    } else {
                        Glide.with(getActivity())
                                .load(filePath)
//                            .placeholder(R.drawable.im_uikit_chat_loading_message_resource)
                                .dontAnimate()
                                .diskCacheStrategy(DiskCacheStrategy.NONE)
                                .fitCenter()
                                .error(thDrawable)
                                .into(mPhotoView);
                    }
                } catch (OutOfMemoryError error) {
                    Glide.with(getActivity())
                            .load(filePath)
                            .error(R.drawable.im_uikit_pic_default)
                            .into(mPhotoView);
                }

//                getPresenter().loadImage(mPhotoView, filePath, ImageView.ScaleType.FIT_CENTER,
//                        options.outWidth, options.outHeight);
            } else {
                loadError();
            }
        } else {
            loadError();
        }
    }

    /**
     * 保存图片
     */
    private void savePhoto() {
        //保存图片至本地
        ImageFileInfo imageFileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("ERROR: Save image, but image file info is null.");
            return;
        }
        String suffix = ToolUtil.getLastString(imageFileInfo.getFileName(), ".");

        String fileName;
        if (suffix.equals(ConstDef.GIF_TYPE)) {
            //文件名称
            fileName = "imageexport" + System.currentTimeMillis() + ".gif";
        } else {
            //文件名称
            fileName = "imageexport" + System.currentTimeMillis() + ".jpeg";
        }
        File srcFile = null;

        //选择需要保存的文件
        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (rawFileInfo != null && isFileDownload(rawFileInfo.getFilePath())) {
            srcFile = new File(rawFileInfo.getFilePath());
        } else if (hdFileInfo != null && isFileDownload(hdFileInfo.getFilePath())) {
            srcFile = new File(hdFileInfo.getFilePath());
        } else if (!TextUtils.isEmpty(imageFileInfo.getFilePath()) && isFileDownload(imageFileInfo.getFilePath())) {
            srcFile = new File(imageFileInfo.getFilePath());
        }
        if (srcFile != null) {
            getPresenter().saveFile(srcFile, FilePathUtils.getImageRecPath(), fileName);
        } else {
            CommonTool.showToast(R.string.im_uikit_hint_save_image_failed);
        }
        if (mDialog != null) {
            mDialog.dismiss();
        }
    }

    /**
     * 删除图片
     */
    private void deletePhoto() {
        getPresenter().deleteMsg(dataSource);
        mDialog.dismiss();
    }

    /**
     * @param path
     * @return
     */
    public boolean isFileDownload(String path) {
        if (TextUtils.isEmpty(path)) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(path, options);
        return options.outWidth > 0 && options.outHeight > 0;
    }

    @Override
    public void onFileDownloadFinish() {
        ImageFileInfo imageFileInfo = (ImageFileInfo) dataSource.getFileInfo();
        if (imageFileInfo == null) {
            LogUtil.e("onFileDownloadFinish imageFileInfo is null.");
        }
        preLoadImage(imageFileInfo);
    }

    private void preLoadImage(ImageFileInfo imageFileInfo) {

        FileInfo rawFileInfo = imageFileInfo.getRawFileInfo();
        if (rawFileInfo != null && FileUtils.isFileExists(rawFileInfo.getFilePath())) {
            mLoadingPbar.setVisibility(View.GONE);
            loadImage(rawFileInfo.getFilePath(), true, imageFileInfo.getFilePath());
            return;
        }
        FileInfo hdFileInfo = imageFileInfo.getHdFileInfo();
        if (hdFileInfo != null && isFileDownload(hdFileInfo.getFilePath())) {
            mLoadingPbar.setVisibility(View.GONE);
            loadImage(hdFileInfo.getFilePath(), false, imageFileInfo.getFilePath());
        } else {
            loadError();
        }
    }
}
