package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.RecognizeHyperlink;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:40
 * @Version V1.0
 * @Description:
 */
public class ViewSendTextItem extends BaseSendItem {

    /**
     * 文本消息显示控件
     */
    private TextView mContentTv;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_text;
    }

    @Override
    protected void injectView() {
        super.injectView();

        mContentTv = (TextView) findViewById(R.id.tv_content);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        mContentTv.setText(EmotionUtils.formatNormalSpanContent(dataSource.getContent(),
                        getActivity())
        );

        RecognizeHyperlink.getInstance().recognizeHyperlinks(new BaseSendItem.MyLongClick() {
            @Override
            public void onLongClick() {
                showPopDialog();
            }
        }, mContentTv, getActivity(), ConstDef.ALL);
    }

    @Override
    protected void setTxtContentColor(int color) {
        super.setTxtContentColor(color);
        mContentTv.setTextColor(color);
    }
}
