package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:44
 * @Version V1.0
 * @Description:
 */
public class ViewSendVideoItem extends BaseSendItem {

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * 播放标识
     */
    private ImageView mPlayFlagImg;
    /**
     * 文件发送进度
     */
    private CircleProgressBar mLoadingPBar;
    /**
     * 视频时长显示
     */
    private TextView mVideoTimeTv;

    /**
     * 文件下载进度条
     * @return
     */
    private ProgressBar loadProgressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_video;
    }


    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mPlayFlagImg = (ImageView) findViewById(R.id.img_play_flag);
        mLoadingPBar = (CircleProgressBar) findViewById(R.id.pbar_video_loading);
        mVideoTimeTv = (TextView) findViewById(R.id.tv_video_duration);
        loadProgressBar = (ProgressBar) findViewById(R.id.pbar_loading) ;

        mContentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return showPopDialog();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        VideoFileInfo videoFileInfo = (VideoFileInfo) dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("Video file info is null error.");
            return;
        }
        mPlayFlagImg.setVisibility(View.VISIBLE);
        mVideoTimeTv.setVisibility(View.VISIBLE);

        //更新进度
        updateProgress(videoFileInfo.getTranslatePercent());
        //加载缩略图
        loadImage(videoFileInfo);

        mVideoTimeTv.setText(String.format(getStringRes(R.string.im_uikit_video_duration),
                videoFileInfo.getAmountOfTime() / 60,   //分
                videoFileInfo.getAmountOfTime() % 60)); //秒
    }

    /**
     * 加载视频第一帧图片
     *
     * @param fileInfo
     */
    private void loadImage(VideoFileInfo fileInfo) {
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            if (fileInfo.getFileSize() == FileUtils.getFileLength(fileInfo.getFilePath())) {
                updateLoadProgress(false);
                mChatImage.loadImage(fileInfo.getFilePath(),ConstDef.SEND_IMAGE);
                LogUtil.d("createScaledBitmap ViewSendVideoItem state " + fileInfo.getFileState() + " msgId : " + dataSource.getId());
            }
            LogUtil.d("createScaledBitmap ViewSendVideoItem size " + " msgId : " + dataSource.getId());
        } else {
            if (showDefaultImageMessageState(fileInfo,dataSource)) {
                updateLoadProgress(false);
                mVideoTimeTv.setVisibility(View.GONE);
                mPlayFlagImg.setVisibility(View.GONE);
                mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
                LogUtil.d("createScaledBitmap ViewSendVideoItem state1 " + fileInfo.getFileState() + " msgId : " + dataSource.getId());
            } else {
                getPresenter().downLoadFile(dataSource, fileInfo);
                updateLoadProgress(true);
                LogUtil.d("createScaledBitmap ViewSendVideoItem state2 " + fileInfo.getFileState() + " msgId : " + dataSource.getId());
            }
        }
    }

    private boolean showDefaultImageMessageState(VideoFileInfo FileInfo, TalkMessageBean dataSource) {
        return FileInfo.getFileState() == ConstDef.DONE
                || FileInfo.getFileState() == ConstDef.FAIL
                || dataSource.getMessageState() == ConstDef.STATE_SEND_FAILED
                || dataSource.getMessageState() == ConstDef.STATE_SENDING;
    }

    /**
     * 更新文件加载进度
     *
     * @param percent 视频文件发送进度
     */
    private void updateProgress(int percent) {
        if (dataSource.getMessageState() == ConstDef.STATE_SENDING) {
            mPlayFlagImg.setVisibility(View.GONE);
            mLoadingPBar.setVisibility(View.VISIBLE);
            mLoadingPBar.setProgress(percent);
        } else {
            mPlayFlagImg.setVisibility(View.VISIBLE);
            mLoadingPBar.setVisibility(View.GONE);
        }
    }

    /**
     * 下载进度条更新
     */
    private void updateLoadProgress(boolean update) {
        if (update) {
            mPlayFlagImg.setVisibility(View.GONE);
            mChatImage.setVisibility(View.GONE);
            loadProgressBar.setVisibility(View.VISIBLE);
        } else {
            mPlayFlagImg.setVisibility(View.VISIBLE);
            mChatImage.setVisibility(View.VISIBLE);
            loadProgressBar.setVisibility(View.GONE);
        }
    }
}
