/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.base.frame.presenter;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.AdapterBaseView;

public abstract class BaseItemAdapterPresenter<P extends Presenter, D>
extends BaseAdapter {
    protected int position;

    public View getView(int position, View convertView, ViewGroup parent) {
        this.position = position;
        AdapterBaseView<P, D> adapterVu = null;
        if (convertView == null) {
            try {
                int itemViewType = this.getItemViewType(position);
                Class<AdapterBaseView<P, D>> aClass = this.getVuClassByViewType(itemViewType);
                if (aClass == null) {
                    throw new NullPointerException("item view type error!");
                }
                adapterVu = aClass.newInstance();
                adapterVu.setPresenter(this.getPresenter());
                adapterVu.setActivity(this.getActivity());
                adapterVu.init(LayoutInflater.from((Context)parent.getContext()), parent);
                convertView = adapterVu.getView();
                convertView.setTag(adapterVu);
                adapterVu.onViewCreated();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            adapterVu = (AdapterBaseView<P, D>)convertView.getTag();
            adapterVu.onViewReused();
        }
        adapterVu.bindDataSource(position, this.getDataSource(position));
        return convertView;
    }

    protected abstract P getPresenter();

    protected abstract D getDataSource(int var1);

    @NonNull
    protected abstract Class<? extends AdapterBaseView<P, D>> getVuClassByViewType(int var1);

    protected Activity getActivity() {
        return null;
    }
}

