/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.cache.impl;

import android.text.TextUtils;
import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class UserCacheImpl
implements UserCache {
    private UserEntity userEntity;
    private Map<Long, Integer> mPercentMaps = new HashMap<Long, Integer>();

    @Inject
    public UserCacheImpl() {
    }

    @Override
    public void put(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    @Override
    public UserEntity get() {
        return this.userEntity;
    }

    @Override
    public boolean isMine(String account) {
        if (TextUtils.isEmpty((CharSequence)account)) {
            return false;
        }
        if (this.userEntity == null) {
            return false;
        }
        return account.equals(this.userEntity.getAccount());
    }

    @Override
    public void putProgress(long msgId, int percent) {
        if (this.mPercentMaps == null) {
            this.mPercentMaps = new HashMap<Long, Integer>();
        }
        this.mPercentMaps.put(msgId, percent);
    }

    @Override
    public int getProgress(long msgId) {
        return this.mPercentMaps.containsKey(msgId) ? this.mPercentMaps.get(msgId) : 0;
    }

    @Override
    public void removeProgress(long msgId) {
        if (this.mPercentMaps.containsKey(msgId)) {
            this.mPercentMaps.remove(msgId);
        }
    }

    @Override
    public boolean containKey(long msgId) {
        return this.mPercentMaps != null && this.mPercentMaps.containsKey(msgId);
    }

    @Override
    public void clearAllProgress() {
        if (this.mPercentMaps != null && this.mPercentMaps.size() > 0) {
            this.mPercentMaps.clear();
            this.mPercentMaps = null;
        }
    }

    @Override
    public String getImRecallMsg(String account, String groupId) {
        if (null == account) {
            return null;
        }
        if (this.isMine(account)) {
            return ImUiKit.getInstance().getContext().getString(R.string.im_uikit_you_recall_message);
        }
        AccountBean info = IMUiKitProxyImpl.getInstance().getAccount(account, 1);
        if (info != null) {
            return info.getDisplayName() + ImUiKit.getInstance().getContext().getString(R.string.im_uikit_recall_message);
        }
        return account + ImUiKit.getInstance().getContext().getString(R.string.im_uikit_recall_message);
    }
}

